/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.pocketgps.forge;

import club.iananderson.pocketgps.PocketGps;
import club.iananderson.pocketgps.client.PocketGpsClient;
import club.iananderson.pocketgps.config.PocketGpsConfig;
import club.iananderson.pocketgps.forge.impl.curios.CuriosCompat;
import club.iananderson.pocketgps.forge.registry.ForgeRegistration;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="pocketgps")
public final class PocketGpsForge {
    public PocketGpsForge(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        PocketGps.init();
        ForgeRegistration.register(modEventBus);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)PocketGpsConfig.GENERAL_SPEC, "pocketgps-common.toml");
        modEventBus.addListener(ClientModEvents::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void pocketGpsPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.side == LogicalSide.CLIENT) {
            PocketGpsClient.cachePlayerState(event.player);
        }
    }

    @SubscribeEvent
    public void pocketGpsOnPlayerLoad(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        PocketGpsClient.setInitializedMapState(false);
        PocketGpsClient.setIsDrawingMap(false);
        PocketGpsClient.cachePlayerState(player);
    }

    @SubscribeEvent
    public void pocketGpsOnPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        PocketGpsClient.setInitializedMapState(false);
        PocketGpsClient.setIsDrawingMap(false);
        PocketGpsClient.cachePlayerState(player);
    }

    @Mod.EventBusSubscriber(modid="pocketgps", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModEvents {
        @SubscribeEvent
        public static void commonSetup(FMLCommonSetupEvent event) {
            if (PocketGps.curiosLoaded()) {
                PocketGps.LOG.info("Talking to Curios");
                new CuriosCompat().setup(event);
            }
            PocketGps.clientInit();
        }
    }
}

