/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.pocketgps.items;

import club.iananderson.pocketgps.PocketGps;
import club.iananderson.pocketgps.energy.ItemEnergyStorage;
import club.iananderson.pocketgps.items.BaseGps;
import club.iananderson.pocketgps.platform.Services;
import club.iananderson.pocketgps.util.ItemUtil;
import club.iananderson.pocketgps.util.NBTUtil;
import club.iananderson.pocketgps.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class BaseChargeableGps
extends BaseGps
implements ItemEnergyStorage {
    public BaseChargeableGps(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public static int clamp(int min, int value, int max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    @Override
    public void m_7836_(ItemStack itemStack, Level level, Player player) {
        if (PocketGps.gpsNeedPower()) {
            NBTUtil.setInt(itemStack, PocketGps.ENERGY_TAG, 0);
        }
        super.m_7836_(itemStack, level, player);
    }

    public void setEnergyStored(ItemStack energyStorage, int value) {
        NBTUtil.setInt(energyStorage, PocketGps.ENERGY_TAG, BaseChargeableGps.clamp(value, 0, this.getCapacity()));
    }

    public int getEnergyReceive() {
        return PocketGps.gpsMaxInput();
    }

    public int getEnergyExtract() {
        return PocketGps.gpsMaxOutput();
    }

    public int getEnergyCost() {
        return PocketGps.gpsEnergyCost();
    }

    @Override
    public int receiveEnergy(ItemStack energyStorage, int maxReceive, boolean simulate) {
        if (this.getEnergyReceive() == 0) {
            return 0;
        }
        int energyStored = this.getEnergy(energyStorage);
        int energyReceived = Math.min(this.getCapacity() - energyStored, Math.min(this.getEnergyReceive(), maxReceive));
        if (!simulate) {
            this.setEnergyStored(energyStorage, energyStored + energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack energyStorage, int maxExtract, boolean simulate) {
        if (this.getEnergyExtract() == 0) {
            return 0;
        }
        int energyStored = this.getEnergy(energyStorage);
        int energyExtracted = Math.min(energyStored, Math.min(this.getEnergyExtract(), maxExtract));
        if (!simulate) {
            this.setEnergyStored(energyStorage, energyStored - energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergy(ItemStack energyStorage) {
        return energyStorage.m_41784_().m_128451_(PocketGps.ENERGY_TAG);
    }

    @Override
    public int getCapacity() {
        return PocketGps.gpsEnergyCapacity();
    }

    public float getEnergyPercentage(ItemStack energyStorage) {
        if (!PocketGps.gpsNeedPower()) {
            return 1.0f;
        }
        float energyStored = this.getEnergy(energyStorage);
        float energyCapacity = this.getCapacity();
        return energyStored / energyCapacity;
    }

    public String getStoredEnergyText(ItemStack energyStorage) {
        float storedEnergy = this.getEnergy(energyStorage);
        if (storedEnergy < 1000.0f || Screen.m_96638_()) {
            return TextUtil.commaFormat.format(storedEnergy);
        }
        return TextUtil.kFormat.format(storedEnergy / 1000.0f);
    }

    public String getEnergyCapacityText(ItemStack energyStorage) {
        int energyCapacity = this.getCapacity();
        if (energyCapacity < 1000 || Screen.m_96638_()) {
            return TextUtil.commaFormat.format(energyCapacity);
        }
        return TextUtil.kFormat.format(energyCapacity / 1000);
    }

    public String getPercentageText(ItemStack energyStorage) {
        float percentage = this.getEnergyPercentage(energyStorage);
        return TextUtil.percentFormat.format(percentage * 100.0f);
    }

    public void useEnergy(ItemStack energyStorage, int amount) {
        if (energyStorage.m_41783_() != null || energyStorage.m_41783_().m_128441_(PocketGps.ENERGY_TAG)) {
            int stored = Math.min(energyStorage.m_41783_().m_128451_(PocketGps.ENERGY_TAG), this.getCapacity());
            if ((stored -= amount) < 0) {
                stored = 0;
            }
            energyStorage.m_41783_().m_128405_(PocketGps.ENERGY_TAG, stored);
        }
    }

    public void useGPS(Player player, ItemStack energyStorage, int cost) {
        if (this.getEnergy(energyStorage) > 0) {
            this.useEnergy(energyStorage, cost);
        }
    }

    @Override
    public boolean m_142522_(ItemStack energyStorage) {
        return PocketGps.gpsNeedPower() && NBTUtil.getInt(energyStorage, PocketGps.ENERGY_TAG) < this.getCapacity();
    }

    public int m_142159_(ItemStack stack) {
        return 16744454;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(this.getEnergyPercentage(stack) * 13.0f);
    }

    public List<Component> energyTooltips(ItemStack energyStorage) {
        ArrayList<Component> energyTooltips = new ArrayList<Component>();
        String storedEnergy = this.getStoredEnergyText(energyStorage);
        String energyCapacity = this.getEnergyCapacityText(energyStorage);
        String energyUnit = PocketGps.energyUnit().getDisplayName();
        String percentageText = this.getPercentageText(energyStorage);
        if (Services.PLATFORM.getPlatformName().equals("Fabric")) {
            energyUnit = "E";
        }
        energyTooltips.add((Component)Component.m_237110_((String)"item.pocketgps.gps.tooltip.energy.stored", (Object[])new Object[]{storedEnergy, energyCapacity, energyUnit}).m_130940_(ChatFormatting.GOLD));
        if (Screen.m_96638_()) {
            energyTooltips.add((Component)Component.m_237110_((String)"item.pocketgps.gps.tooltip.energy.percent", (Object[])new Object[]{percentageText}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        return energyTooltips;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (PocketGps.gpsNeedPower()) {
            tooltip.addAll(this.energyTooltips(stack));
        }
    }

    public float timeRemaining(ItemStack energyStorage) {
        int energyStored = this.getEnergy(energyStorage);
        int energyCost = this.getEnergyCost();
        return (float)energyStored / (float)(energyCost * 20);
    }

    public void debug(ItemStack energyStorage, Player player, double distance, int energyCost) {
        String storedEnergy = this.getStoredEnergyText(energyStorage);
        String energyCapacity = this.getEnergyCapacityText(energyStorage);
        String energyUnit = PocketGps.energyUnit().getDisplayName();
        MutableComponent storedEnergyText = Component.m_237110_((String)"item.pocketgps.gps.tooltip.energy.stored", (Object[])new Object[]{storedEnergy, energyCapacity, energyUnit}).m_130940_(ChatFormatting.GOLD);
        MutableComponent message = storedEnergyText.m_130946_(" | Walk Time: " + (int)this.timeRemaining(energyStorage) / 60 + " minutes Cost: " + energyCost).m_130940_(ChatFormatting.GREEN);
        storedEnergyText.m_130946_(" | Distance: " + TextUtil.thousandths.format(distance));
        player.m_5661_((Component)message, true);
    }

    public void m_6883_(ItemStack energyStorage, Level level, Entity entity, int slot, boolean selected) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).m_5833_()) {
            Vec3 deltaMovement = player.m_20184_();
            double deltaX = deltaMovement.f_82479_;
            double deltaZ = deltaMovement.f_82481_;
            double distance = Math.abs(deltaX) + Math.abs(deltaZ);
            float energyCost = this.getEnergyCost();
            if (distance > 0.001 && ItemUtil.isGpsOn(energyStorage)) {
                if (player.m_6047_()) {
                    energyCost *= 0.5f;
                }
                if (player.m_20142_()) {
                    energyCost *= 1.5f;
                }
                this.useGPS(player, energyStorage, (int)energyCost);
            }
        }
        super.m_6883_(energyStorage, level, entity, slot, selected);
    }
}

