/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.pocketgps.client;

import club.iananderson.pocketgps.PocketGps;
import club.iananderson.pocketgps.impl.accessories.AccessoriesCompat;
import club.iananderson.pocketgps.impl.curios.CuriosCompat;
import club.iananderson.pocketgps.impl.trinkets.TrinketsCompat;
import club.iananderson.pocketgps.minimap.CurrentMinimap;
import club.iananderson.pocketgps.util.ItemUtil;
import club.iananderson.pocketgps.util.NBTUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public class PocketGpsClient {
    private static class_1799 currentActiveGps = class_1799.field_8037;
    private static boolean isDrawingMap;
    private static boolean initializedMapState;

    @NotNull
    private static class_1799 getGpsFromInventory(class_1661 inventory) {
        int max = inventory.method_5439();
        for (int i = 0; i < max; ++i) {
            class_1799 itemstack = inventory.method_5438(i);
            if (!itemstack.method_31574(PocketGps.GPS.get())) continue;
            return itemstack;
        }
        return class_1799.field_8037;
    }

    @NotNull
    public static class_1799 getGpsFromPlayer(class_1657 player) {
        class_1799 trinketItem;
        class_1799 curioItem;
        class_1799 accessoryItem;
        class_1661 inv = player.method_31548();
        class_1799 mainHandItem = player.method_6047();
        class_1799 offhandItem = player.method_6079();
        class_1799 inventoryItem = PocketGpsClient.getGpsFromInventory(inv);
        if (mainHandItem.method_31574(PocketGps.GPS.get())) {
            return mainHandItem;
        }
        if (offhandItem.method_31574(PocketGps.GPS.get())) {
            return offhandItem;
        }
        if (PocketGps.accessoriesLoaded() && !(accessoryItem = AccessoriesCompat.getGpsInAccessory(player)).method_7960()) {
            return accessoryItem;
        }
        if (PocketGps.curiosLoaded() && !(curioItem = CuriosCompat.getGpsInCurio(player)).method_7960()) {
            return curioItem;
        }
        if (PocketGps.trinketsLoaded() && !(trinketItem = TrinketsCompat.getGpsInTrinket(player)).method_7960()) {
            return trinketItem;
        }
        return inventoryItem;
    }

    public static void cachePlayerState(class_1657 player) {
        currentActiveGps = PocketGpsClient.getGpsFromPlayer(player);
        boolean validGps = PocketGpsClient.isValidGPS(currentActiveGps);
        if (!initializedMapState) {
            PocketGpsClient.setIsDrawingMap(!validGps);
            PocketGpsClient.setInitializedMapState(true);
        }
        if (PocketGpsClient.getCurrentActiveGps().method_7960()) {
            CurrentMinimap.removeMinimap(player);
        } else if (!PocketGpsClient.getCurrentActiveGps().method_7960()) {
            if (!validGps) {
                CurrentMinimap.removeMinimap(player);
            } else {
                CurrentMinimap.displayMinimap(player);
            }
        }
    }

    public static class_1799 getCurrentActiveGps() {
        return currentActiveGps;
    }

    public static boolean isValidGPS(class_1799 gps) {
        boolean hasPower = NBTUtil.getInt(gps, PocketGps.ENERGY_TAG) > 0;
        boolean gpsOn = ItemUtil.isGpsOn(PocketGpsClient.getCurrentActiveGps());
        if (PocketGps.gpsNeedPower()) {
            return gpsOn && hasPower;
        }
        return gpsOn;
    }

    public static boolean isDrawingMap() {
        return isDrawingMap;
    }

    public static void setIsDrawingMap(boolean state) {
        isDrawingMap = state;
    }

    public static boolean isInitializedMapState() {
        return initializedMapState;
    }

    public static void setInitializedMapState(boolean state) {
        initializedMapState = state;
    }
}

