/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.pocketgps.client;

import club.iananderson.pocketgps.PocketGps;
import club.iananderson.pocketgps.impl.curios.CuriosCompat;
import club.iananderson.pocketgps.impl.trinkets.TrinketsCompat;
import club.iananderson.pocketgps.minimap.CurrentMinimap;
import club.iananderson.pocketgps.util.ItemUtil;
import club.iananderson.pocketgps.util.NBTUtil;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PocketGpsClient {
    private static ItemStack currentActiveGps = ItemStack.f_41583_;
    private static boolean isDrawingMap;
    private static boolean initializedMapState;

    @NotNull
    private static ItemStack getGpsFromInventory(Inventory inventory) {
        int max = inventory.m_6643_();
        for (int i = 0; i < max; ++i) {
            ItemStack itemstack = inventory.m_8020_(i);
            if (!itemstack.m_150930_(PocketGps.GPS.get())) continue;
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public static ItemStack getGpsFromPlayer(Player player) {
        ItemStack trinketItem;
        ItemStack curioItem;
        Inventory inv = player.m_150109_();
        ItemStack mainHandItem = player.m_21205_();
        ItemStack offhandItem = player.m_21206_();
        ItemStack inventoryItem = PocketGpsClient.getGpsFromInventory(inv);
        if (mainHandItem.m_150930_(PocketGps.GPS.get())) {
            return mainHandItem;
        }
        if (offhandItem.m_150930_(PocketGps.GPS.get())) {
            return offhandItem;
        }
        if (PocketGps.curiosLoaded() && !(curioItem = CuriosCompat.getGpsInCurio(player)).m_41619_()) {
            return curioItem;
        }
        if (PocketGps.trinketsLoaded() && !(trinketItem = TrinketsCompat.getGpsInTrinket(player)).m_41619_()) {
            return trinketItem;
        }
        return inventoryItem;
    }

    public static void cachePlayerState(Player player) {
        currentActiveGps = PocketGpsClient.getGpsFromPlayer(player);
        boolean validGps = PocketGpsClient.isValidGPS(currentActiveGps);
        if (!initializedMapState) {
            PocketGpsClient.setIsDrawingMap(!validGps);
            PocketGpsClient.setInitializedMapState(true);
        }
        if (PocketGpsClient.getCurrentActiveGps().m_41619_()) {
            CurrentMinimap.removeMinimap(player);
        } else if (!PocketGpsClient.getCurrentActiveGps().m_41619_()) {
            if (!validGps) {
                CurrentMinimap.removeMinimap(player);
            } else {
                CurrentMinimap.displayMinimap(player);
            }
        }
    }

    public static ItemStack getCurrentActiveGps() {
        return currentActiveGps;
    }

    public static boolean isValidGPS(ItemStack gps) {
        boolean hasPower = NBTUtil.getInt(gps, PocketGps.ENERGY_TAG) > 0;
        boolean gpsOn = ItemUtil.isGpsOn(PocketGpsClient.getCurrentActiveGps());
        if (PocketGps.gpsNeedPower()) {
            return gpsOn && hasPower;
        }
        return gpsOn;
    }

    public static boolean isDrawingMap() {
        return isDrawingMap;
    }

    public static void setIsDrawingMap(boolean state) {
        isDrawingMap = state;
    }

    public static boolean isInitializedMapState() {
        return initializedMapState;
    }

    public static void setInitializedMapState(boolean state) {
        initializedMapState = state;
    }
}

