/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.pocketgps.minimap;

import club.iananderson.pocketgps.PocketGps;
import club.iananderson.pocketgps.client.PocketGpsClient;
import club.iananderson.pocketgps.impl.xaero.minimap.MinimapEffect;
import club.iananderson.pocketgps.impl.xaero.worldmap.WorldMapEffect;
import club.iananderson.pocketgps.platform.Services;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.ui.UIManager;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CurrentMinimap {
    private static boolean minimapLoaded(Minimaps minimap) {
        String modID = minimap.getModID();
        return Services.PLATFORM.isModLoaded(modID);
    }

    public static List<Minimaps> loadedMinimaps() {
        ArrayList<Minimaps> values = new ArrayList<Minimaps>(List.of(Minimaps.values()));
        ArrayList<Minimaps> loaded = new ArrayList<Minimaps>();
        values.forEach(minimaps -> {
            if (CurrentMinimap.minimapLoaded(minimaps)) {
                loaded.add((Minimaps)((Object)minimaps));
            }
        });
        return loaded;
    }

    public static boolean noMinimapLoaded() {
        return CurrentMinimap.loadedMinimaps().isEmpty();
    }

    public static boolean xaeroLoaded() {
        return CurrentMinimap.minimapLoaded(Minimaps.XAERO) || CurrentMinimap.minimapLoaded(Minimaps.XAERO_FAIRPLAY);
    }

    public static boolean journeyMapLoaded() {
        return CurrentMinimap.minimapLoaded(Minimaps.JOURNEYMAP);
    }

    public static boolean onlyFtbChunksLoaded() {
        return CurrentMinimap.minimapLoaded(Minimaps.FTB_CHUNKS) && CurrentMinimap.loadedMinimaps().size() == 1;
    }

    public static void displayMinimap(Player player) {
        if (player instanceof ServerPlayer || PocketGpsClient.isDrawingMap()) {
            return;
        }
        if (CurrentMinimap.journeyMapLoaded() && player.f_19853_.f_46443_) {
            UIManager.INSTANCE.setMiniMapEnabled(true);
        }
        if (CurrentMinimap.xaeroLoaded()) {
            if (player.m_21023_(MinimapEffect.NO_MINIMAP)) {
                player.m_21195_(MinimapEffect.NO_MINIMAP);
            }
            if (PocketGps.worldMapLoaded() && player.m_21023_(WorldMapEffect.NO_WORLD_MAP)) {
                player.m_21195_(WorldMapEffect.NO_WORLD_MAP);
            }
        }
        if (CurrentMinimap.onlyFtbChunksLoaded() && player.f_19853_.f_46443_) {
            FTBChunksClientConfig.MINIMAP_ENABLED.set((Object)true);
        }
        PocketGpsClient.setIsDrawingMap(true);
    }

    public static void removeMinimap(Player player) {
        if (player instanceof ServerPlayer || !PocketGpsClient.isDrawingMap()) {
            return;
        }
        if (CurrentMinimap.journeyMapLoaded() && player.f_19853_.f_46443_) {
            UIManager.INSTANCE.setMiniMapEnabled(false);
        }
        if (CurrentMinimap.xaeroLoaded()) {
            if (!player.m_21023_(MinimapEffect.NO_MINIMAP)) {
                player.m_7292_(MinimapEffect.noMiniMap);
            }
            if (PocketGps.worldMapLoaded() && !player.m_21023_(WorldMapEffect.NO_WORLD_MAP)) {
                player.m_7292_(WorldMapEffect.noWorldMap);
            }
        }
        if (CurrentMinimap.onlyFtbChunksLoaded() && player.f_19853_.f_46443_) {
            FTBChunksClientConfig.MINIMAP_ENABLED.set((Object)false);
        }
        PocketGpsClient.setIsDrawingMap(false);
    }

    public static enum Minimaps {
        XAERO("xaerominimap", (MutableComponent)new TranslatableComponent("minimap.pocketgps.xaero")),
        XAERO_FAIRPLAY("xaerominimapfair", (MutableComponent)new TranslatableComponent("minimap.pocketgps.xaero")),
        JOURNEYMAP("journeymap", (MutableComponent)new TranslatableComponent("minimap.pocketgps.journeymap")),
        FTB_CHUNKS("ftbchunks", (MutableComponent)new TranslatableComponent("minimap.pocketgps.ftb"));

        private final String modID;
        private final MutableComponent modName;

        private Minimaps(String modID, MutableComponent modName) {
            this.modID = modID;
            this.modName = modName;
        }

        public String getModID() {
            return this.modID;
        }

        public MutableComponent getModName() {
            return this.modName;
        }
    }
}

