/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.pocketgps.items;

import club.iananderson.pocketgps.PocketGps;
import club.iananderson.pocketgps.energy.ItemEnergyStorage;
import club.iananderson.pocketgps.items.BaseGps;
import club.iananderson.pocketgps.platform.Services;
import club.iananderson.pocketgps.util.ItemUtil;
import club.iananderson.pocketgps.util.NBTUtil;
import club.iananderson.pocketgps.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public abstract class BaseChargeableGps
extends BaseGps
implements ItemEnergyStorage {
    public BaseChargeableGps(class_1792.class_1793 properties) {
        super(properties.method_7889(1));
    }

    public static int clamp(int min, int value, int max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    @Override
    public void method_7843(class_1799 itemStack, class_1937 level, class_1657 player) {
        if (PocketGps.gpsNeedPower()) {
            NBTUtil.setInt(itemStack, PocketGps.ENERGY_TAG, 0);
        }
        super.method_7843(itemStack, level, player);
    }

    public void setEnergyStored(class_1799 energyStorage, int value) {
        NBTUtil.setInt(energyStorage, PocketGps.ENERGY_TAG, BaseChargeableGps.clamp(value, 0, this.getCapacity()));
    }

    public int getEnergyReceive() {
        return PocketGps.gpsMaxInput();
    }

    public int getEnergyExtract() {
        return PocketGps.gpsMaxOutput();
    }

    public int getEnergyCost() {
        return PocketGps.gpsEnergyCost();
    }

    @Override
    public int receiveEnergy(class_1799 energyStorage, int maxReceive, boolean simulate) {
        if (this.getEnergyReceive() == 0) {
            return 0;
        }
        int energyStored = this.getEnergy(energyStorage);
        int energyReceived = Math.min(this.getCapacity() - energyStored, Math.min(this.getEnergyReceive(), maxReceive));
        if (!simulate) {
            this.setEnergyStored(energyStorage, energyStored + energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(class_1799 energyStorage, int maxExtract, boolean simulate) {
        if (this.getEnergyExtract() == 0) {
            return 0;
        }
        int energyStored = this.getEnergy(energyStorage);
        int energyExtracted = Math.min(energyStored, Math.min(this.getEnergyExtract(), maxExtract));
        if (!simulate) {
            this.setEnergyStored(energyStorage, energyStored - energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergy(class_1799 energyStorage) {
        return energyStorage.method_7948().method_10550(PocketGps.ENERGY_TAG);
    }

    @Override
    public int getCapacity() {
        return PocketGps.gpsEnergyCapacity();
    }

    public float getEnergyPercentage(class_1799 energyStorage) {
        if (!PocketGps.gpsNeedPower()) {
            return 1.0f;
        }
        float energyStored = this.getEnergy(energyStorage);
        float energyCapacity = this.getCapacity();
        return energyStored / energyCapacity;
    }

    public String getStoredEnergyText(class_1799 energyStorage) {
        float storedEnergy = this.getEnergy(energyStorage);
        if (storedEnergy < 1000.0f || class_437.method_25442()) {
            return TextUtil.commaFormat.format(storedEnergy);
        }
        return TextUtil.kFormat.format(storedEnergy / 1000.0f);
    }

    public String getEnergyCapacityText(class_1799 energyStorage) {
        int energyCapacity = this.getCapacity();
        if (energyCapacity < 1000 || class_437.method_25442()) {
            return TextUtil.commaFormat.format(energyCapacity);
        }
        return TextUtil.kFormat.format(energyCapacity / 1000);
    }

    public String getPercentageText(class_1799 energyStorage) {
        float percentage = this.getEnergyPercentage(energyStorage);
        return TextUtil.percentFormat.format(percentage * 100.0f);
    }

    public void useEnergy(class_1799 energyStorage, int amount) {
        if (energyStorage.method_7969() != null || energyStorage.method_7969().method_10545(PocketGps.ENERGY_TAG)) {
            int stored = Math.min(energyStorage.method_7969().method_10550(PocketGps.ENERGY_TAG), this.getCapacity());
            if ((stored -= amount) < 0) {
                stored = 0;
            }
            energyStorage.method_7969().method_10569(PocketGps.ENERGY_TAG, stored);
        }
    }

    public void useGPS(class_1657 player, class_1799 energyStorage, int cost) {
        if (this.getEnergy(energyStorage) > 0) {
            this.useEnergy(energyStorage, cost);
        }
    }

    @Override
    public boolean method_31567(class_1799 energyStorage) {
        return PocketGps.gpsNeedPower() && NBTUtil.getInt(energyStorage, PocketGps.ENERGY_TAG) < this.getCapacity();
    }

    public int method_31571(class_1799 stack) {
        return 16744454;
    }

    public int method_31569(class_1799 stack) {
        return Math.round(this.getEnergyPercentage(stack) * 13.0f);
    }

    public List<class_2561> energyTooltips(class_1799 energyStorage) {
        ArrayList<class_2561> energyTooltips = new ArrayList<class_2561>();
        String storedEnergy = this.getStoredEnergyText(energyStorage);
        String energyCapacity = this.getEnergyCapacityText(energyStorage);
        String energyUnit = PocketGps.energyUnit().getDisplayName();
        String percentageText = this.getPercentageText(energyStorage);
        if (Services.PLATFORM.getPlatformName().equals("Fabric")) {
            energyUnit = "E";
        }
        energyTooltips.add((class_2561)class_2561.method_43469((String)"item.pocketgps.gps.tooltip.energy.stored", (Object[])new Object[]{storedEnergy, energyCapacity, energyUnit}).method_27692(class_124.field_1065));
        if (class_437.method_25442()) {
            energyTooltips.add((class_2561)class_2561.method_43469((String)"item.pocketgps.gps.tooltip.energy.percent", (Object[])new Object[]{percentageText}).method_27692(class_124.field_1063));
        }
        return energyTooltips;
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        super.method_7851(stack, worldIn, tooltip, flagIn);
        if (PocketGps.gpsNeedPower()) {
            tooltip.addAll(this.energyTooltips(stack));
        }
    }

    public float timeRemaining(class_1799 energyStorage) {
        int energyStored = this.getEnergy(energyStorage);
        int energyCost = this.getEnergyCost();
        return (float)energyStored / (float)(energyCost * 20);
    }

    public void debug(class_1799 energyStorage, class_1657 player, double distance, int energyCost) {
        String storedEnergy = this.getStoredEnergyText(energyStorage);
        String energyCapacity = this.getEnergyCapacityText(energyStorage);
        String energyUnit = PocketGps.energyUnit().getDisplayName();
        class_5250 storedEnergyText = class_2561.method_43469((String)"item.pocketgps.gps.tooltip.energy.stored", (Object[])new Object[]{storedEnergy, energyCapacity, energyUnit}).method_27692(class_124.field_1065);
        class_5250 message = storedEnergyText.method_27693(" | Walk Time: " + (int)this.timeRemaining(energyStorage) / 60 + " minutes Cost: " + energyCost).method_27692(class_124.field_1060);
        storedEnergyText.method_27693(" | Distance: " + TextUtil.thousandths.format(distance));
        player.method_7353((class_2561)message, true);
    }

    public void method_7888(class_1799 energyStorage, class_1937 level, class_1297 entity, int slot, boolean selected) {
        class_1657 player;
        if (entity instanceof class_1657 && !(player = (class_1657)entity).method_7325()) {
            class_243 deltaMovement = player.method_18798();
            double deltaX = deltaMovement.field_1352;
            double deltaZ = deltaMovement.field_1350;
            double distance = Math.abs(deltaX) + Math.abs(deltaZ);
            float energyCost = this.getEnergyCost();
            if (distance > 0.001 && ItemUtil.isGpsOn(energyStorage)) {
                if (player.method_18276()) {
                    energyCost *= 0.5f;
                }
                if (player.method_5624()) {
                    energyCost *= 1.5f;
                }
                this.useGPS(player, energyStorage, (int)energyCost);
            }
        }
        super.method_7888(energyStorage, level, entity, slot, selected);
    }
}

