/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.pocketgps.minimap;

import club.iananderson.pocketgps.PocketGps;
import club.iananderson.pocketgps.client.PocketGpsClient;
import club.iananderson.pocketgps.impl.xaero.minimap.MinimapEffect;
import club.iananderson.pocketgps.impl.xaero.worldmap.WorldMapEffect;
import club.iananderson.pocketgps.platform.Services;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.ui.UIManager;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class CurrentMinimap {
    private static boolean minimapLoaded(Minimaps minimap) {
        String modID = minimap.getModID();
        return Services.PLATFORM.isModLoaded(modID);
    }

    public static List<Minimaps> loadedMinimaps() {
        ArrayList<Minimaps> values = new ArrayList<Minimaps>(List.of(Minimaps.values()));
        ArrayList<Minimaps> loaded = new ArrayList<Minimaps>();
        values.forEach(minimaps -> {
            if (CurrentMinimap.minimapLoaded(minimaps)) {
                loaded.add((Minimaps)((Object)minimaps));
            }
        });
        return loaded;
    }

    public static boolean noMinimapLoaded() {
        return CurrentMinimap.loadedMinimaps().isEmpty();
    }

    public static boolean xaeroLoaded() {
        return CurrentMinimap.minimapLoaded(Minimaps.XAERO) || CurrentMinimap.minimapLoaded(Minimaps.XAERO_FAIRPLAY);
    }

    public static boolean journeyMapLoaded() {
        return CurrentMinimap.minimapLoaded(Minimaps.JOURNEYMAP);
    }

    public static boolean onlyFtbChunksLoaded() {
        return CurrentMinimap.minimapLoaded(Minimaps.FTB_CHUNKS) && CurrentMinimap.loadedMinimaps().size() == 1;
    }

    public static void displayMinimap(class_1657 player) {
        if (player == null || PocketGpsClient.isDrawingMap()) {
            return;
        }
        if (CurrentMinimap.journeyMapLoaded() && player.field_6002.field_9236) {
            UIManager.INSTANCE.setMiniMapEnabled(true);
        }
        if (CurrentMinimap.xaeroLoaded()) {
            if (player.method_6059(MinimapEffect.NO_MINIMAP)) {
                player.method_6016(MinimapEffect.NO_MINIMAP);
            }
            if (PocketGps.worldMapLoaded() && player.method_6059(WorldMapEffect.NO_WORLD_MAP)) {
                player.method_6016(WorldMapEffect.NO_WORLD_MAP);
            }
        }
        if (CurrentMinimap.onlyFtbChunksLoaded() && player.field_6002.field_9236) {
            FTBChunksClientConfig.MINIMAP_ENABLED.set((Object)true);
        }
        PocketGpsClient.setIsDrawingMap(true);
    }

    public static void removeMinimap(class_1657 player) {
        if (player == null || !PocketGpsClient.isDrawingMap()) {
            return;
        }
        if (CurrentMinimap.journeyMapLoaded() && player.field_6002.field_9236) {
            UIManager.INSTANCE.setMiniMapEnabled(false);
        }
        if (CurrentMinimap.xaeroLoaded()) {
            if (!player.method_6059(MinimapEffect.NO_MINIMAP)) {
                player.method_6092(MinimapEffect.noMiniMap);
            }
            if (PocketGps.worldMapLoaded() && !player.method_6059(WorldMapEffect.NO_WORLD_MAP)) {
                player.method_6092(WorldMapEffect.noWorldMap);
            }
        }
        if (CurrentMinimap.onlyFtbChunksLoaded() && player.field_6002.field_9236) {
            FTBChunksClientConfig.MINIMAP_ENABLED.set((Object)false);
        }
        PocketGpsClient.setIsDrawingMap(false);
    }

    public static enum Minimaps {
        XAERO("xaerominimap", class_2561.method_43471((String)"minimap.pocketgps.xaero")),
        XAERO_FAIRPLAY("xaerominimapfair", class_2561.method_43471((String)"minimap.pocketgps.xaero")),
        JOURNEYMAP("journeymap", class_2561.method_43471((String)"minimap.pocketgps.journeymap")),
        FTB_CHUNKS("ftbchunks", class_2561.method_43471((String)"minimap.pocketgps.ftb"));

        private final String modID;
        private final class_5250 modName;

        private Minimaps(String modID, class_5250 modName) {
            this.modID = modID;
            this.modName = modName;
        }

        public String getModID() {
            return this.modID;
        }

        public class_5250 getModName() {
            return this.modName;
        }
    }
}

