/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.world.placers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.satisfy.bloomingnature.core.registry.PlacerTypesRegistry;
import org.jetbrains.annotations.NotNull;

public class RodBirchFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<RodBirchFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> RodBirchFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(cdc -> cdc.height)).and((App)Codec.FLOAT.fieldOf("offset_chance").forGetter(cdc -> Float.valueOf(cdc.offsetChance))).apply((Applicative)instance, RodBirchFoliagePlacer::new));
    protected final int height;
    protected final float offsetChance;

    public RodBirchFoliagePlacer(IntProvider radius, IntProvider offset, int height, float offsetChance) {
        super(radius, offset);
        this.height = height;
        this.offsetChance = offsetChance;
    }

    @NotNull
    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)PlacerTypesRegistry.ROD_BIRCH_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter foligateSetter, RandomSource random, TreeConfiguration treeConfiguration, int trunkHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int radius, int offset) {
        BoundingBox box = new BoundingBox(attachment.pos());
        int offsetValue = this.offset.sample(random);
        int radiusValue = this.radius.sample(random);
        for (int placeOffset = offsetValue; placeOffset >= offsetValue - foliageHeight; --placeOffset) {
            int baseHeight = attachment.radiusOffset() > 0 ? Math.max(radiusValue + attachment.radiusOffset() - 1 - placeOffset / 2, 0) : Math.max(radiusValue + attachment.radiusOffset() - placeOffset / 2, 0);
            this.placeLeavesRow(level, foligateSetter, random, treeConfiguration, attachment.pos(), baseHeight, placeOffset, attachment.doubleTrunk(), box);
        }
    }

    protected void placeLeavesRow(LevelSimulatedReader level, FoliagePlacer.FoliageSetter foliageSetter, RandomSource random, TreeConfiguration treeConfiguration, BlockPos blockPos, int radius, int yy, boolean isBig, BoundingBox box) {
        int offset = isBig ? 1 : 0;
        BlockPos.MutableBlockPos placePos = new BlockPos.MutableBlockPos();
        for (int xx = -radius; xx <= radius + offset; ++xx) {
            for (int zz = -radius; zz <= radius + offset; ++zz) {
                if (this.shouldSkipLocationSigned(random, xx, yy, zz, radius, isBig)) continue;
                placePos.setWithOffset((Vec3i)blockPos, xx, yy, zz);
                this.placeLeaf(level, foliageSetter, random, treeConfiguration, (BlockPos)placePos, box);
                if (!(random.nextFloat() < this.offsetChance)) continue;
                Direction offsetDir = Direction.getRandom((RandomSource)random);
                this.placeLeaf(level, foliageSetter, random, treeConfiguration, placePos.relative(offsetDir), box);
            }
        }
    }

    protected void placeLeaf(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration configuration, BlockPos placePos, BoundingBox box) {
        FoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)configuration, (BlockPos)placePos);
        box.encapsulate(new BlockPos((Vec3i)placePos));
    }

    public int foliageHeight(RandomSource random, int i, TreeConfiguration treeConfiguration) {
        return this.height;
    }

    protected boolean shouldSkipLocation(RandomSource random, int baseHeight, int dx, int dy, int dz, boolean giantTrunk) {
        if (baseHeight + dy >= 4) {
            return true;
        }
        return baseHeight * baseHeight + dy * dy > dz * dz;
    }
}

