/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.bloomingnature.BloomingNature;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class WanderingGardenerModel<T extends WanderingTrader>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(BloomingNature.identifier("wandering_gardener"), "main");
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;

    public WanderingGardenerModel(ModelPart root) {
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.RightLeg = this.body.getChild("RightLeg");
        this.LeftLeg = this.body.getChild("LeftLeg");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 20).addBox(-4.0f, -24.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 53).addBox(-4.0f, -15.0f, -3.0f, 8.0f, 5.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-24.0f, (float)0.0f));
        PartDefinition helmet = head.addOrReplaceChild("helmet", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -10.6f, -4.0f, 8.0f, 4.0f, 8.0f, new CubeDeformation(0.5f)).texOffs(48, -8).addBox(4.5f, -19.1f, -4.0f, 0.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition brim = head.addOrReplaceChild("brim", CubeListBuilder.create().texOffs(30, 47).addBox(-8.0f, -8.0f, -6.0f, 16.0f, 16.0f, 1.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition backpack = body.addOrReplaceChild("backpack", CubeListBuilder.create().texOffs(0, 40).addBox(-4.0f, -23.0f, 3.0f, 8.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition flower_r1 = backpack.addOrReplaceChild("flower_r1", CubeListBuilder.create().texOffs(44, 2).addBox(4.0f, -31.0f, 0.0f, 0.0f, 9.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.0908f, (float)0.0f));
        PartDefinition flower_r2 = backpack.addOrReplaceChild("flower_r2", CubeListBuilder.create().texOffs(32, 7).addBox(-4.0f, -28.0f, 2.0f, 0.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0908f, (float)0.0f));
        PartDefinition arms = body.addOrReplaceChild("arms", CubeListBuilder.create().texOffs(40, 38).addBox(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(44, 22).addBox(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(44, 22).mirror().addBox(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-22.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition RightLeg = body.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(0, 22).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition LeftLeg = body.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(0, 22).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.0f, (float)-12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float f, float g, float h, float i, float j) {
        boolean bl = false;
        if (entity != null) {
            bl = entity.getUnhappyCounter() > 0;
        }
        this.head.yRot = i * ((float)Math.PI / 180);
        this.head.xRot = j * ((float)Math.PI / 180);
        if (bl) {
            this.head.zRot = 0.3f * Mth.sin((float)(0.45f * h));
            this.head.xRot = 0.4f;
        } else {
            this.head.zRot = 0.0f;
        }
        this.RightLeg.xRot = Mth.cos((float)(f * 0.6662f)) * 1.4f * g * 0.5f;
        this.LeftLeg.xRot = Mth.cos((float)(f * 0.6662f + (float)Math.PI)) * 1.4f * g * 0.5f;
        this.RightLeg.yRot = 0.0f;
        this.LeftLeg.yRot = 0.0f;
    }

    public ModelPart getHead() {
        return this.head;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.root().render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    @NotNull
    public ModelPart root() {
        return this.body;
    }
}

