/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.world.placers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.satisfy.bloomingnature.core.registry.PlacerTypesRegistry;
import org.jetbrains.annotations.NotNull;

public class FanPalmFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<FanPalmFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> FanPalmFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).and((App)Codec.intRange((int)0, (int)16).fieldOf("leaf_length").forGetter(placer -> placer.leafLength)).apply((Applicative)instance, FanPalmFoliagePlacer::new));
    private final int leafLength;

    public FanPalmFoliagePlacer(IntProvider range, IntProvider offset, int leafLength) {
        super(range, offset);
        this.leafLength = leafLength;
    }

    @NotNull
    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)PlacerTypesRegistry.FAN_PALM_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter foliageSetter, RandomSource random, TreeConfiguration config, int trunkHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int radius, int offset) {
        int i;
        BlockPos blockPos = attachment.pos();
        int attempts = random.nextInt(this.leafLength) + 3;
        this.placeLeaf(level, foliageSetter, random, config, blockPos);
        BlockPos.MutableBlockPos mutable = blockPos.mutable();
        for (i = 0; i > -1; --i) {
            int j = 1 + i;
            this.placeLeavesRow(level, foliageSetter, random, config, blockPos, j, i, false);
        }
        for (i = 0; i < 10; ++i) {
            mutable.setWithOffset((Vec3i)blockPos, random.nextInt(radius) - random.nextInt(radius), random.nextInt(radius) - radius + 2, random.nextInt(radius) - random.nextInt(radius));
            this.placeLeaf(level, foliageSetter, random, config, (BlockPos)mutable);
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos.MutableBlockPos horiz = new BlockPos.MutableBlockPos(blockPos.getX(), blockPos.getY(), blockPos.getZ());
            int gravity = 0;
            int maxLimit = attempts / 3;
            for (int i2 = 0; i2 < attempts; ++i2) {
                horiz.move(dir);
                if (gravity >= maxLimit) {
                    gravity = 0;
                    this.placeLeaf(level, foliageSetter, random, config, (BlockPos)horiz);
                    horiz.move(Direction.DOWN);
                } else {
                    ++gravity;
                }
                this.placeLeaf(level, foliageSetter, random, config, (BlockPos)horiz);
            }
        }
    }

    public int foliageHeight(RandomSource random, int i, TreeConfiguration config) {
        return 0;
    }

    protected void placeLeaf(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, BlockPos pos) {
        if (level.isStateAtPosition(pos, state -> state.isAir() || state.is(config.foliageProvider.getState(random, pos).getBlock()))) {
            setter.set(pos, config.foliageProvider.getState(random, pos));
        }
    }

    protected boolean shouldSkipLocation(RandomSource random, int dx, int dy, int dz, int radius, boolean large) {
        return false;
    }
}

