/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.world.placers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.satisfy.bloomingnature.core.registry.ObjectRegistry;
import net.satisfy.bloomingnature.core.registry.PlacerTypesRegistry;
import org.jetbrains.annotations.NotNull;

public class LarchFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<LarchFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> LarchFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).and((App)IntProvider.codec((int)0, (int)24).fieldOf("trunk_height").forGetter(placer -> placer.trunkHeight)).apply((Applicative)instance, LarchFoliagePlacer::new));
    private final IntProvider trunkHeight;

    public LarchFoliagePlacer(IntProvider radius, IntProvider offset, IntProvider trunkHeight) {
        super(radius, offset);
        this.trunkHeight = trunkHeight;
    }

    @NotNull
    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)PlacerTypesRegistry.LARCH_FOLIAGE_PLACER.get();
    }

    public int foliageHeight(RandomSource random, int trunkHeight, TreeConfiguration config) {
        return Math.max(12, trunkHeight - this.trunkHeight.sample(random));
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, int trunkHeight, FoliagePlacer.FoliageAttachment node, int foliageHeight, int radius, int offset) {
        int l;
        BlockPos blockPos = node.pos();
        BlockPos.MutableBlockPos mutable = blockPos.mutable();
        for (l = 0; l < trunkHeight; ++l) {
            BlockPos trunkPos = blockPos.above(l);
            setter.set(trunkPos, ((Block)ObjectRegistry.LARCH_LOG.get()).defaultBlockState());
        }
        for (l = offset; l >= -foliageHeight - 4; --l) {
            if (l >= offset - 2) {
                mutable.setWithOffset((Vec3i)blockPos, 0, l, 0);
                LarchFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
                continue;
            }
            if (l < offset - foliageHeight - 4) continue;
            mutable.setWithOffset((Vec3i)blockPos, 0, l, 0);
            if (random.nextBoolean()) {
                LarchFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.NORTH, 1).relative(Direction.EAST, 1));
            }
            if (random.nextBoolean()) {
                LarchFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.NORTH, 1).relative(Direction.WEST, 1));
            }
            if (random.nextBoolean()) {
                LarchFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.SOUTH, 1).relative(Direction.EAST, 1));
            }
            if (random.nextBoolean()) {
                LarchFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.relative(Direction.SOUTH, 1).relative(Direction.WEST, 1));
            }
            this.placeLeavesRow(level, setter, random, config, blockPos, Math.max(1, radius - 1), l, node.doubleTrunk());
        }
    }

    protected boolean shouldSkipLocation(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        return dx == radius && dz == radius && radius > 0;
    }

    protected void placeLeavesRow(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, BlockPos centerPos, int radius, int y, boolean giantTrunk) {
        int i = giantTrunk ? 1 : 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                if (this.shouldSkipLocationSigned(random, j, y, k, radius, giantTrunk)) continue;
                mutable.setWithOffset((Vec3i)centerPos, j, y, k);
                LarchFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)setter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
            }
        }
    }
}

