/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.neoforge.core.mixin;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.npc.WanderingTraderSpawner;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.storage.ServerLevelData;
import net.satisfy.bloomingnature.core.registry.EntityTypeRegistry;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WanderingTraderSpawner.class})
public abstract class WanderingTraderManagerMixin
implements CustomSpawner {
    @Shadow
    @Final
    private ServerLevelData serverLevelData;

    @Shadow
    @Nullable
    protected abstract BlockPos findSpawnPositionNear(LevelReader var1, BlockPos var2, int var3);

    @Shadow
    protected abstract boolean hasEnoughSpace(BlockGetter var1, BlockPos var2);

    @Inject(method={"spawn(Lnet/minecraft/server/level/ServerLevel;)Z"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/world/entity/EntityType;spawn(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/MobSpawnType;)Lnet/minecraft/world/entity/Entity;")}, cancellable=true)
    private void trySpawn(ServerLevel world, CallbackInfoReturnable<Boolean> cir) {
        if (world.random.nextBoolean()) {
            ServerPlayer playerEntity = world.getRandomPlayer();
            assert (playerEntity != null);
            BlockPos blockPos = playerEntity.blockPosition();
            PoiManager pointOfInterestStorage = world.getPoiManager();
            Optional optional = pointOfInterestStorage.find(type -> type.is(PoiTypes.MEETING), pos -> true, blockPos, 48, PoiManager.Occupancy.ANY);
            BlockPos blockPos2 = optional.orElse(blockPos);
            BlockPos blockPos3 = this.findSpawnPositionNear((LevelReader)world, blockPos2, 48);
            if (blockPos3 != null && this.hasEnoughSpace((BlockGetter)world, blockPos3)) {
                if (world.getBiome(blockPos3).is(Biomes.THE_VOID)) {
                    return;
                }
                WanderingTrader wanderingTraderEntity = (WanderingTrader)((EntityType)EntityTypeRegistry.WANDERING_GARDENER.get()).spawn(world, blockPos3, MobSpawnType.EVENT);
                if (wanderingTraderEntity != null) {
                    for (int j = 0; j < 2; ++j) {
                        BlockPos blockPos4 = this.findSpawnPositionNear((LevelReader)world, wanderingTraderEntity.blockPosition(), 4);
                        if (blockPos4 != null) continue;
                        return;
                    }
                    this.serverLevelData.setWanderingTraderId(wanderingTraderEntity.getUUID());
                    wanderingTraderEntity.setDespawnDelay(48000);
                    wanderingTraderEntity.setWanderTarget(blockPos2);
                    wanderingTraderEntity.restrictTo(blockPos2, 16);
                    cir.setReturnValue((Object)true);
                }
            }
        }
    }
}

