/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.external.org.spongepowered.configurate.serialize;

import app.simplecloud.external.io.leangen.geantyref.GenericTypeReflector;
import app.simplecloud.external.io.leangen.geantyref.TypeToken;
import app.simplecloud.external.org.checkerframework.checker.nullness.qual.Nullable;
import app.simplecloud.external.org.spongepowered.configurate.serialize.ScalarSerializer;
import app.simplecloud.external.org.spongepowered.configurate.serialize.SerializationException;
import app.simplecloud.external.org.spongepowered.configurate.util.EnumLookup;
import java.lang.reflect.Type;
import java.util.function.Predicate;

final class EnumValueSerializer
extends ScalarSerializer<Enum<?>> {
    EnumValueSerializer() {
        super(new TypeToken<Enum<?>>(){});
    }

    @Override
    public Enum<?> deserialize(Type type, Object obj) throws SerializationException {
        String enumConstant = obj.toString();
        @Nullable Enum ret2 = EnumLookup.lookupEnum(GenericTypeReflector.erase(type).asSubclass(Enum.class), enumConstant);
        if (ret2 == null) {
            throw new SerializationException(type, "Invalid enum constant provided, expected a value of enum, got " + enumConstant);
        }
        return ret2;
    }

    @Override
    public Object serialize(Enum<?> item, Predicate<Class<?>> typeSupported) {
        return item.name();
    }
}

