/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.api.shared.repository;

import app.simplecloud.external.kotlinx.coroutines.BuildersKt;
import app.simplecloud.external.kotlinx.coroutines.CoroutineScope;
import app.simplecloud.external.kotlinx.coroutines.CoroutineScopeKt;
import app.simplecloud.external.kotlinx.coroutines.Dispatchers;
import app.simplecloud.external.kotlinx.coroutines.Job;
import app.simplecloud.external.org.jetbrains.annotations.NotNull;
import app.simplecloud.external.org.jetbrains.annotations.Nullable;
import app.simplecloud.external.org.spongepowered.configurate.CommentedConfigurationNode;
import app.simplecloud.external.org.spongepowered.configurate.ConfigurationNode;
import app.simplecloud.external.org.spongepowered.configurate.ConfigurationOptions;
import app.simplecloud.external.org.spongepowered.configurate.kotlin.ObjectMappingKt;
import app.simplecloud.external.org.spongepowered.configurate.loader.ParsingException;
import app.simplecloud.external.org.spongepowered.configurate.serialize.SerializationException;
import app.simplecloud.external.org.spongepowered.configurate.serialize.TypeSerializer;
import app.simplecloud.external.org.spongepowered.configurate.serialize.TypeSerializerCollection;
import app.simplecloud.external.org.spongepowered.configurate.yaml.NodeStyle;
import app.simplecloud.external.org.spongepowered.configurate.yaml.YamlConfigurationLoader;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001(B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000fH\u0016J\u0017\u0010\u001a\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001d\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J\u001b\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00028\u0000\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J\b\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00028\u00000\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006)"}, d2={"Lapp/simplecloud/plugin/api/shared/repository/YamlDirectoryRepository;", "E", "", "directory", "Ljava/nio/file/Path;", "clazz", "Ljava/lang/Class;", "<init>", "(Ljava/nio/file/Path;Ljava/lang/Class;)V", "watchService", "Ljava/nio/file/WatchService;", "kotlin.jvm.PlatformType", "Ljava/nio/file/WatchService;", "loaders", "", "Ljava/io/File;", "Lapp/simplecloud/external/org/spongepowered/configurate/yaml/YamlConfigurationLoader;", "entities", "getEntities", "()Ljava/util/Map;", "delete", "", "element", "(Ljava/lang/Object;)Z", "getAll", "", "load", "watchUpdateEvent", "", "file", "(Ljava/io/File;)Ljava/lang/Object;", "deleteFile", "save", "fileName", "", "entity", "(Ljava/lang/String;Ljava/lang/Object;)V", "getOrCreateLoader", "registerWatcher", "Lapp/simplecloud/external/kotlinx/coroutines/Job;", "GenericEnumSerializer", "plugin-api"})
@SourceDebugExtension(value={"SMAP\nYamlDirectoryRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YamlDirectoryRepository.kt\napp/simplecloud/plugin/api/shared/repository/YamlDirectoryRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,156:1\n1#2:157\n1#2:171\n774#3:158\n865#3,2:159\n1611#3,9:161\n1863#3:170\n1864#3:172\n1620#3:173\n381#4,7:174\n*S KotlinDebug\n*F\n+ 1 YamlDirectoryRepository.kt\napp/simplecloud/plugin/api/shared/repository/YamlDirectoryRepository\n*L\n44#1:171\n43#1:158\n43#1:159,2\n44#1:161,9\n44#1:170\n44#1:172\n44#1:173\n83#1:174,7\n*E\n"})
public abstract class YamlDirectoryRepository<E> {
    @NotNull
    private final Path directory;
    @NotNull
    private final Class<E> clazz;
    private final WatchService watchService;
    @NotNull
    private final Map<File, YamlConfigurationLoader> loaders;
    @NotNull
    private final Map<File, E> entities;

    public YamlDirectoryRepository(@NotNull Path directory, @NotNull Class<E> clazz) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        this.directory = directory;
        this.clazz = clazz;
        this.watchService = FileSystems.getDefault().newWatchService();
        this.loaders = new LinkedHashMap();
        this.entities = new LinkedHashMap();
    }

    @NotNull
    protected final Map<File, E> getEntities() {
        return this.entities;
    }

    public final boolean delete(E element) {
        Object v0;
        block2: {
            Iterable iterable = this.entities.keySet();
            for (Object t : iterable) {
                File it = (File)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(this.entities.get(it), element)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        File file = v0;
        if (file == null) {
            return false;
        }
        File file2 = file;
        return this.deleteFile(file2);
    }

    @NotNull
    public final List<E> getAll() {
        return CollectionsKt.toList((Iterable)this.entities.values());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<E> load() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        if (!this.directory.toFile().exists()) {
            this.directory.toFile().mkdirs();
        }
        this.registerWatcher();
        List<Path> list = Files.list(this.directory).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            if (!(!it.toFile().isDirectory() && StringsKt.endsWith$default((String)((Object)it).toString(), (String)".yml", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            E it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Path it = (Path)element$iv$iv;
            boolean bl2 = false;
            File file = it.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            if (this.load(file) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public void watchUpdateEvent(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
    }

    private final E load(File file) {
        try {
            YamlConfigurationLoader loader = this.getOrCreateLoader(file);
            CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load(ConfigurationOptions.defaults());
            E e = node.get(this.clazz);
            if (e == null) {
                return null;
            }
            E entity = e;
            this.entities.put(file, entity);
            return entity;
        }
        catch (ParsingException ex) {
            boolean existedBefore = this.entities.containsKey(file);
            if (existedBefore) {
                return null;
            }
            return null;
        }
    }

    private final boolean deleteFile(File file) {
        boolean deletedSuccessfully = file.delete();
        boolean removedSuccessfully = this.entities.remove(file) != null;
        return deletedSuccessfully && removedSuccessfully;
    }

    public final void save(@NotNull String fileName, E entity) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File file = this.directory.resolve(fileName).toFile();
        Intrinsics.checkNotNull((Object)file);
        YamlConfigurationLoader loader = this.getOrCreateLoader(file);
        CommentedConfigurationNode node = loader.createNode(ConfigurationOptions.defaults().serializers(YamlDirectoryRepository::save$lambda$3));
        node.set(this.clazz, (Object)entity);
        loader.save(node);
        this.entities.put(file, entity);
    }

    private final YamlConfigurationLoader getOrCreateLoader(File file) {
        YamlConfigurationLoader yamlConfigurationLoader;
        Map<File, YamlConfigurationLoader> $this$getOrPut$iv = this.loaders;
        boolean $i$f$getOrPut = false;
        YamlConfigurationLoader value$iv = $this$getOrPut$iv.get(file);
        if (value$iv == null) {
            boolean bl = false;
            YamlConfigurationLoader yamlConfigurationLoader2 = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(file.toPath())).nodeStyle(NodeStyle.BLOCK).nodeStyle(NodeStyle.BLOCK).defaultOptions(YamlDirectoryRepository::getOrCreateLoader$lambda$6$lambda$5)).build();
            Intrinsics.checkNotNullExpressionValue((Object)yamlConfigurationLoader2, (String)"build(...)");
            YamlConfigurationLoader answer$iv = yamlConfigurationLoader2;
            $this$getOrPut$iv.put(file, answer$iv);
            yamlConfigurationLoader = answer$iv;
        } else {
            yamlConfigurationLoader = value$iv;
        }
        return yamlConfigurationLoader;
    }

    private final Job registerWatcher() {
        WatchEvent.Kind[] kindArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
        this.directory.register(this.watchService, kindArray);
        return BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ YamlDirectoryRepository<E> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            WatchKey key = YamlDirectoryRepository.access$getWatchService$p(this.this$0).take();
                            for (WatchEvent<?> event : key.pollEvents()) {
                                File file;
                                Path path;
                                ? obj = event.context();
                                if ((obj instanceof Path ? (Path)obj : null) == null) continue;
                                path = path;
                                Path resolvedPath = YamlDirectoryRepository.access$getDirectory$p(this.this$0).resolve(path);
                                if (Files.isDirectory(resolvedPath, new LinkOption[0]) || !StringsKt.endsWith$default((String)((Object)resolvedPath).toString(), (String)".yml", (boolean)false, (int)2, null)) continue;
                                WatchEvent.Kind<?> kind = event.kind();
                                WatchEvent.Kind<?> kind2 = kind;
                                if (Intrinsics.areEqual(kind2, StandardWatchEventKinds.ENTRY_CREATE)) {
                                    file = resolvedPath.toFile();
                                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                                    YamlDirectoryRepository.access$load(this.this$0, file);
                                    continue;
                                }
                                if (Intrinsics.areEqual(kind2, StandardWatchEventKinds.ENTRY_MODIFY)) {
                                    File file2 = resolvedPath.toFile();
                                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
                                    YamlDirectoryRepository.access$load(this.this$0, file2);
                                    file = resolvedPath.toFile();
                                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                                    this.this$0.watchUpdateEvent(file);
                                    continue;
                                }
                                if (!Intrinsics.areEqual(kind2, StandardWatchEventKinds.ENTRY_DELETE)) continue;
                                file = resolvedPath.toFile();
                                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                                YamlDirectoryRepository.access$deleteFile(this.this$0, file);
                            }
                            key.reset();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void save$lambda$3(TypeSerializerCollection.Builder it) {
        it.register(Enum.class, (TypeSerializer)GenericEnumSerializer.INSTANCE);
    }

    private static final void getOrCreateLoader$lambda$6$lambda$5$lambda$4(TypeSerializerCollection.Builder builder) {
        builder.registerAnnotatedObjects(ObjectMappingKt.objectMapperFactory());
        builder.register(Enum.class, (TypeSerializer)GenericEnumSerializer.INSTANCE);
    }

    private static final ConfigurationOptions getOrCreateLoader$lambda$6$lambda$5(ConfigurationOptions options) {
        return options.serializers(YamlDirectoryRepository::getOrCreateLoader$lambda$6$lambda$5$lambda$4);
    }

    public static final /* synthetic */ WatchService access$getWatchService$p(YamlDirectoryRepository $this) {
        return $this.watchService;
    }

    public static final /* synthetic */ Path access$getDirectory$p(YamlDirectoryRepository $this) {
        return $this.directory;
    }

    public static final /* synthetic */ Object access$load(YamlDirectoryRepository $this, File file) {
        return $this.load(file);
    }

    public static final /* synthetic */ boolean access$deleteFile(YamlDirectoryRepository $this, File file) {
        return $this.deleteFile(file);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lapp/simplecloud/plugin/api/shared/repository/YamlDirectoryRepository$GenericEnumSerializer;", "Lapp/simplecloud/external/org/spongepowered/configurate/serialize/TypeSerializer;", "", "<init>", "()V", "deserialize", "type", "Ljava/lang/reflect/Type;", "node", "Lapp/simplecloud/external/org/spongepowered/configurate/ConfigurationNode;", "serialize", "", "obj", "plugin-api"})
    private static final class GenericEnumSerializer
    implements TypeSerializer<Enum<?>> {
        @NotNull
        public static final GenericEnumSerializer INSTANCE = new GenericEnumSerializer();

        private GenericEnumSerializer() {
        }

        @Override
        @NotNull
        public Enum<?> deserialize(@NotNull Type type, @NotNull ConfigurationNode node) {
            Object t;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            String string = node.getString();
            if (string == null) {
                throw new SerializationException("No value present in node");
            }
            String value = string;
            if (!(type instanceof Class) || !((Class)type).isEnum()) {
                throw new SerializationException("Type is not an enum class");
            }
            try {
                t = Enum.valueOf((Class)type, value);
            }
            catch (IllegalArgumentException e) {
                throw new SerializationException("Invalid enum constant");
            }
            return t;
        }

        @Override
        public void serialize(@NotNull Type type, @Nullable Enum<?> obj, @NotNull ConfigurationNode node) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Enum<?> enum_ = obj;
            node.set(enum_ != null ? enum_.name() : null);
        }
    }
}

