/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.connection.velocity;

import app.simplecloud.external.org.jetbrains.annotations.NotNull;
import app.simplecloud.plugin.connection.shared.ConnectionAndTargetConfig;
import app.simplecloud.plugin.connection.shared.ServerConnectionPlugin;
import app.simplecloud.plugin.connection.shared.config.CommandConfig;
import app.simplecloud.plugin.connection.shared.server.ServerConnectionInfo;
import com.google.inject.Inject;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.KickedFromServerEvent;
import com.velocitypowered.api.event.player.PlayerChooseInitialServerEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;

@Plugin(id="simplecloud-connection", name="simplecloud-connection", version="0.0.1", url="https://github.com/theSimpleCloud/server-connection-plugin", authors={"Fllip", "hmtill"}, dependencies={@Dependency(id="simplecloud-api")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B#\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0019H\u0007J\b\u0010\u001a\u001a\u00020\u0013H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lapp/simplecloud/plugin/connection/velocity/VelocityServerConnectionPlugin;", "", "dataDirectory", "Ljava/nio/file/Path;", "server", "Lcom/velocitypowered/api/proxy/ProxyServer;", "logger", "Ljava/util/logging/Logger;", "<init>", "(Ljava/nio/file/Path;Lcom/velocitypowered/api/proxy/ProxyServer;Ljava/util/logging/Logger;)V", "getDataDirectory", "()Ljava/nio/file/Path;", "serverConnection", "Lapp/simplecloud/plugin/connection/shared/ServerConnectionPlugin;", "Lcom/velocitypowered/api/proxy/Player;", "miniMessage", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "Lapp/simplecloud/external/org/jetbrains/annotations/NotNull;", "onProxyInitialize", "", "event", "Lcom/velocitypowered/api/event/proxy/ProxyInitializeEvent;", "onPlayerChooseInitialServer", "Lcom/velocitypowered/api/event/player/PlayerChooseInitialServerEvent;", "onKickedFromServer", "Lcom/velocitypowered/api/event/player/KickedFromServerEvent;", "registerCommands", "createCommand", "Lcom/velocitypowered/api/command/BrigadierCommand;", "commandConfig", "Lapp/simplecloud/plugin/connection/shared/config/CommandConfig;", "server-connection-plugin"})
@SourceDebugExtension(value={"SMAP\nVelocityServerConnectionPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VelocityServerConnectionPlugin.kt\napp/simplecloud/plugin/connection/velocity/VelocityServerConnectionPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,150:1\n1863#2:151\n1864#2:154\n1557#2:155\n1628#2,3:156\n37#3,2:152\n*S KotlinDebug\n*F\n+ 1 VelocityServerConnectionPlugin.kt\napp/simplecloud/plugin/connection/velocity/VelocityServerConnectionPlugin\n*L\n104#1:151\n104#1:154\n45#1:155\n45#1:156,3\n106#1:152,2\n*E\n"})
public final class VelocityServerConnectionPlugin {
    @NotNull
    private final Path dataDirectory;
    @NotNull
    private final ProxyServer server;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ServerConnectionPlugin<Player> serverConnection;
    @NotNull
    private final MiniMessage miniMessage;

    @Inject
    public VelocityServerConnectionPlugin(@DataDirectory @NotNull Path dataDirectory, @NotNull ProxyServer server, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)dataDirectory, (String)"dataDirectory");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.dataDirectory = dataDirectory;
        this.server = server;
        this.logger = logger;
        this.serverConnection = new ServerConnectionPlugin<Player>(this.dataDirectory, () -> VelocityServerConnectionPlugin.serverConnection$lambda$1(this), VelocityServerConnectionPlugin::serverConnection$lambda$2);
        MiniMessage miniMessage = MiniMessage.miniMessage();
        Intrinsics.checkNotNullExpressionValue((Object)miniMessage, (String)"miniMessage(...)");
        this.miniMessage = miniMessage;
    }

    @NotNull
    public final Path getDataDirectory() {
        return this.dataDirectory;
    }

    @Subscribe
    public final void onProxyInitialize(@NotNull ProxyInitializeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.registerCommands();
    }

    @Subscribe
    public final void onPlayerChooseInitialServer(@NotNull PlayerChooseInitialServerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        String serverConnectionInfoName = this.serverConnection.getServerNameForLogin(player);
        if (serverConnectionInfoName == null) {
            event.getPlayer().disconnect(this.miniMessage.deserialize((Object)this.serverConnection.getConfig().getNetworkJoinTargets().getNoTargetConnectionFoundMessage()));
            return;
        }
        Optional serverInfo = this.server.getServer(serverConnectionInfoName);
        serverInfo.ifPresent(arg_0 -> VelocityServerConnectionPlugin.onPlayerChooseInitialServer$lambda$4(arg_0 -> VelocityServerConnectionPlugin.onPlayerChooseInitialServer$lambda$3(event, arg_0), arg_0));
    }

    @Subscribe
    public final void onKickedFromServer(@NotNull KickedFromServerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        String string = event.getServer().getServerInfo().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Pair<ConnectionAndTargetConfig, String> connectionAndTargetConfigToServerName = this.serverConnection.getConnectionAndNameForFallback(player, string);
        if (connectionAndTargetConfigToServerName == null) {
            event.setResult((KickedFromServerEvent.ServerKickResult)KickedFromServerEvent.DisconnectPlayer.create((Component)this.miniMessage.deserialize((Object)this.serverConnection.getConfig().getFallbackConnectionsConfig().getNoTargetConnectionFoundMessage())));
            return;
        }
        String serverName = (String)connectionAndTargetConfigToServerName.component2();
        if (Intrinsics.areEqual((Object)event.getServer().getServerInfo().getName(), (Object)serverName)) {
            return;
        }
        if (event.getPlayer().getCurrentServer().isEmpty()) {
            return;
        }
        this.server.getServer(serverName).ifPresent(arg_0 -> VelocityServerConnectionPlugin.onKickedFromServer$lambda$6(arg_0 -> VelocityServerConnectionPlugin.onKickedFromServer$lambda$5(event, arg_0), arg_0));
    }

    private final void registerCommands() {
        CommandManager commandManager = this.server.getCommandManager();
        Iterable $this$forEach$iv = this.serverConnection.getCommandConfigs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommandConfig it = (CommandConfig)element$iv;
            boolean bl = false;
            Collection $this$toTypedArray$iv = it.getAliases();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            CommandMeta commandMeta = commandManager.metaBuilder(it.getName()).aliases(Arrays.copyOf(stringArray, stringArray.length)).plugin((Object)this).build();
            BrigadierCommand commandToRegister = this.createCommand(it);
            commandManager.register(commandMeta, (Command)commandToRegister);
        }
    }

    private final BrigadierCommand createCommand(CommandConfig commandConfig) {
        LiteralCommandNode commandNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder((String)commandConfig.getName()).requires(arg_0 -> VelocityServerConnectionPlugin.createCommand$lambda$8(commandConfig, arg_0))).executes(arg_0 -> VelocityServerConnectionPlugin.createCommand$lambda$11(this, commandConfig, arg_0))).build();
        return new BrigadierCommand(commandNode);
    }

    /*
     * WARNING - void declaration
     */
    private static final List serverConnection$lambda$1(VelocityServerConnectionPlugin this$0) {
        void $this$mapTo$iv$iv;
        Collection collection = this$0.server.getAllServers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllServers(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RegisteredServer registeredServer = (RegisteredServer)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            String string = it.getServerInfo().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            collection2.add(new ServerConnectionInfo(string, it.getPlayersConnected().size()));
        }
        return (List)destination$iv$iv;
    }

    private static final boolean serverConnection$lambda$2(Player player, String permission) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        return player.hasPermission(permission);
    }

    private static final Unit onPlayerChooseInitialServer$lambda$3(PlayerChooseInitialServerEvent $event, RegisteredServer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $event.setInitialServer(it);
        return Unit.INSTANCE;
    }

    private static final void onPlayerChooseInitialServer$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit onKickedFromServer$lambda$5(KickedFromServerEvent $event, RegisteredServer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $event.setResult(KickedFromServerEvent.RedirectPlayer.create((RegisteredServer)it));
        return Unit.INSTANCE;
    }

    private static final void onKickedFromServer$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean createCommand$lambda$8(CommandConfig $commandConfig, CommandSource it) {
        return ((CharSequence)$commandConfig.getPermission()).length() == 0 || it.hasPermission($commandConfig.getPermission());
    }

    private static final Unit createCommand$lambda$11$lambda$9(Player $player, RegisteredServer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $player.createConnectionRequest(it).fireAndForget();
        return Unit.INSTANCE;
    }

    private static final void createCommand$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final int createCommand$lambda$11(VelocityServerConnectionPlugin this$0, CommandConfig $commandConfig, CommandContext it) {
        Object object = it.getSource();
        Player player = object instanceof Player ? (Player)object : null;
        if (player == null) {
            return 0;
        }
        Player player2 = player;
        Optional optional = player2.getCurrentServer();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getCurrentServer(...)");
        ServerConnection serverConnection = (ServerConnection)OptionalsKt.getOrNull((Optional)optional);
        String currentServerName = serverConnection != null && (serverConnection = serverConnection.getServerInfo()) != null ? serverConnection.getName() : null;
        Pair<ConnectionAndTargetConfig, String> connectionToServerName = this$0.serverConnection.getConnectionAndNameForCommand(player2, $commandConfig);
        if (connectionToServerName == null) {
            player2.sendMessage(this$0.miniMessage.deserialize((Object)$commandConfig.getNoTargetConnectionFound()));
            return 1;
        }
        if (currentServerName != null && ((ConnectionAndTargetConfig)connectionToServerName.getFirst()).getConnectionConfig().getServerNameMatcher().matches(currentServerName)) {
            player2.sendMessage(this$0.miniMessage.deserialize((Object)$commandConfig.getAlreadyConnectedMessage()));
            return 1;
        }
        Optional registeredServer = this$0.server.getServer((String)connectionToServerName.getSecond());
        registeredServer.ifPresent(arg_0 -> VelocityServerConnectionPlugin.createCommand$lambda$11$lambda$10(arg_0 -> VelocityServerConnectionPlugin.createCommand$lambda$11$lambda$9(player2, arg_0), arg_0));
        return 1;
    }
}

