/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.external.org.apache.commons.io.input;

import app.simplecloud.external.org.apache.commons.io.TaggedIOException;
import app.simplecloud.external.org.apache.commons.io.input.ProxyReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.UUID;

public class TaggedReader
extends ProxyReader {
    private final Serializable tag = UUID.randomUUID();

    public TaggedReader(Reader proxy) {
        super(proxy);
    }

    @Override
    protected void handleIOException(IOException e) throws IOException {
        throw new TaggedIOException(e, this.tag);
    }

    public boolean isCauseOf(Throwable exception) {
        return TaggedIOException.isTaggedWith(exception, this.tag);
    }

    public void throwIfCauseOf(Throwable throwable) throws IOException {
        TaggedIOException.throwCauseIfTaggedWith(throwable, this.tag);
    }
}

