/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.external.org.apache.commons.io.output;

import app.simplecloud.external.org.apache.commons.io.Charsets;
import app.simplecloud.external.org.apache.commons.io.FileUtils;
import app.simplecloud.external.org.apache.commons.io.IOUtils;
import app.simplecloud.external.org.apache.commons.io.build.AbstractStreamBuilder;
import app.simplecloud.external.org.apache.commons.io.output.ProxyWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Objects;

public class FileWriterWithEncoding
extends ProxyWriter {
    public static Builder builder() {
        return new Builder();
    }

    private static OutputStreamWriter initWriter(File file, Object encoding, boolean append2) throws IOException {
        Objects.requireNonNull(file, "file");
        OutputStream outputStream = null;
        boolean fileExistedAlready = file.exists();
        try {
            outputStream = FileUtils.newOutputStream(file, append2);
            if (encoding == null || encoding instanceof Charset) {
                return new OutputStreamWriter(outputStream, Charsets.toCharset((Charset)encoding));
            }
            if (encoding instanceof CharsetEncoder) {
                return new OutputStreamWriter(outputStream, (CharsetEncoder)encoding);
            }
            return new OutputStreamWriter(outputStream, (String)encoding);
        }
        catch (IOException | RuntimeException ex) {
            try {
                IOUtils.close((Closeable)outputStream);
            }
            catch (IOException e) {
                ex.addSuppressed(e);
            }
            if (!fileExistedAlready) {
                FileUtils.deleteQuietly(file);
            }
            throw ex;
        }
    }

    @Deprecated
    public FileWriterWithEncoding(File file, Charset charset) throws IOException {
        this(file, charset, false);
    }

    @Deprecated
    public FileWriterWithEncoding(File file, Charset encoding, boolean append2) throws IOException {
        this(FileWriterWithEncoding.initWriter(file, encoding, append2));
    }

    @Deprecated
    public FileWriterWithEncoding(File file, CharsetEncoder charsetEncoder) throws IOException {
        this(file, charsetEncoder, false);
    }

    @Deprecated
    public FileWriterWithEncoding(File file, CharsetEncoder charsetEncoder, boolean append2) throws IOException {
        this(FileWriterWithEncoding.initWriter(file, charsetEncoder, append2));
    }

    @Deprecated
    public FileWriterWithEncoding(File file, String charsetName) throws IOException {
        this(file, charsetName, false);
    }

    @Deprecated
    public FileWriterWithEncoding(File file, String charsetName, boolean append2) throws IOException {
        this(FileWriterWithEncoding.initWriter(file, charsetName, append2));
    }

    private FileWriterWithEncoding(OutputStreamWriter outputStreamWriter) {
        super(outputStreamWriter);
    }

    @Deprecated
    public FileWriterWithEncoding(String fileName, Charset charset) throws IOException {
        this(new File(fileName), charset, false);
    }

    @Deprecated
    public FileWriterWithEncoding(String fileName, Charset charset, boolean append2) throws IOException {
        this(new File(fileName), charset, append2);
    }

    @Deprecated
    public FileWriterWithEncoding(String fileName, CharsetEncoder encoding) throws IOException {
        this(new File(fileName), encoding, false);
    }

    @Deprecated
    public FileWriterWithEncoding(String fileName, CharsetEncoder charsetEncoder, boolean append2) throws IOException {
        this(new File(fileName), charsetEncoder, append2);
    }

    @Deprecated
    public FileWriterWithEncoding(String fileName, String charsetName) throws IOException {
        this(new File(fileName), charsetName, false);
    }

    @Deprecated
    public FileWriterWithEncoding(String fileName, String charsetName, boolean append2) throws IOException {
        this(new File(fileName), charsetName, append2);
    }

    public static class Builder
    extends AbstractStreamBuilder<FileWriterWithEncoding, Builder> {
        private boolean append;
        private CharsetEncoder charsetEncoder = super.getCharset().newEncoder();

        @Override
        public FileWriterWithEncoding get() throws IOException {
            if (this.charsetEncoder != null && this.getCharset() != null && !this.charsetEncoder.charset().equals(this.getCharset())) {
                throw new IllegalStateException(String.format("Mismatched Charset(%s) and CharsetEncoder(%s)", this.getCharset(), this.charsetEncoder.charset()));
            }
            Object encoder = this.charsetEncoder != null ? this.charsetEncoder : this.getCharset();
            return new FileWriterWithEncoding(FileWriterWithEncoding.initWriter(this.checkOrigin().getFile(), encoder, this.append));
        }

        public Builder setAppend(boolean append2) {
            this.append = append2;
            return this;
        }

        public Builder setCharsetEncoder(CharsetEncoder charsetEncoder) {
            this.charsetEncoder = charsetEncoder;
            return this;
        }
    }
}

