/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.connection.bungeecord;

import app.simplecloud.external.org.jetbrains.annotations.NotNull;
import app.simplecloud.plugin.connection.shared.ConnectionAndTargetConfig;
import app.simplecloud.plugin.connection.shared.ServerConnectionPlugin;
import app.simplecloud.plugin.connection.shared.config.CommandConfig;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ%\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lapp/simplecloud/plugin/connection/bungeecord/BungeeCordCommand;", "Lnet/md_5/bungee/api/plugin/Command;", "serverConnection", "Lapp/simplecloud/plugin/connection/shared/ServerConnectionPlugin;", "Lnet/md_5/bungee/api/connection/ProxiedPlayer;", "commandConfig", "Lapp/simplecloud/plugin/connection/shared/config/CommandConfig;", "proxyServer", "Lnet/md_5/bungee/api/ProxyServer;", "miniMessage", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "<init>", "(Lapp/simplecloud/plugin/connection/shared/ServerConnectionPlugin;Lapp/simplecloud/plugin/connection/shared/config/CommandConfig;Lnet/md_5/bungee/api/ProxyServer;Lnet/kyori/adventure/text/minimessage/MiniMessage;)V", "execute", "", "sender", "Lnet/md_5/bungee/api/CommandSender;", "args", "", "", "(Lnet/md_5/bungee/api/CommandSender;[Ljava/lang/String;)V", "server-connection-plugin"})
@SourceDebugExtension(value={"SMAP\nBungeeCordCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BungeeCordCommand.kt\napp/simplecloud/plugin/connection/bungeecord/BungeeCordCommand\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,54:1\n37#2,2:55\n*S KotlinDebug\n*F\n+ 1 BungeeCordCommand.kt\napp/simplecloud/plugin/connection/bungeecord/BungeeCordCommand\n*L\n24#1:55,2\n*E\n"})
public final class BungeeCordCommand
extends Command {
    @NotNull
    private final ServerConnectionPlugin<ProxiedPlayer> serverConnection;
    @NotNull
    private final CommandConfig commandConfig;
    @NotNull
    private final ProxyServer proxyServer;
    @NotNull
    private final MiniMessage miniMessage;

    public BungeeCordCommand(@NotNull ServerConnectionPlugin<ProxiedPlayer> serverConnection, @NotNull CommandConfig commandConfig, @NotNull ProxyServer proxyServer, @NotNull MiniMessage miniMessage) {
        Intrinsics.checkNotNullParameter(serverConnection, (String)"serverConnection");
        Intrinsics.checkNotNullParameter((Object)commandConfig, (String)"commandConfig");
        Intrinsics.checkNotNullParameter((Object)proxyServer, (String)"proxyServer");
        Intrinsics.checkNotNullParameter((Object)miniMessage, (String)"miniMessage");
        Collection $this$toTypedArray$iv = commandConfig.getAliases();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        super(commandConfig.getName(), commandConfig.getPermission(), Arrays.copyOf(stringArray, stringArray.length));
        this.serverConnection = serverConnection;
        this.commandConfig = commandConfig;
        this.proxyServer = proxyServer;
        this.miniMessage = miniMessage;
    }

    public void execute(@NotNull CommandSender sender, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ProxiedPlayer player = (ProxiedPlayer)sender;
        String currentServerName = player.getServer().getInfo().getName();
        Pair<ConnectionAndTargetConfig, String> connectionToServerName = this.serverConnection.getConnectionAndNameForCommand(player, this.commandConfig);
        if (connectionToServerName == null) {
            BaseComponent[] baseComponentArray = BungeeComponentSerializer.get().serialize((Component)this.miniMessage.deserialize(this.commandConfig.getNoTargetConnectionFound()));
            player.sendMessage(Arrays.copyOf(baseComponentArray, baseComponentArray.length));
            return;
        }
        if (currentServerName != null && ((ConnectionAndTargetConfig)connectionToServerName.getFirst()).getConnectionConfig().getServerNameMatcher().matches(currentServerName)) {
            Object o = this.miniMessage.deserialize(this.commandConfig.getAlreadyConnectedMessage());
            Intrinsics.checkNotNullExpressionValue(o, (String)"deserialize(...)");
            Object miniMessageComponent = o;
            BaseComponent[] baseComponentArray = BungeeComponentSerializer.get().serialize((Component)miniMessageComponent);
            Intrinsics.checkNotNullExpressionValue((Object)baseComponentArray, (String)"serialize(...)");
            BaseComponent[] component = baseComponentArray;
            player.sendMessage(Arrays.copyOf(component, component.length));
            return;
        }
        ServerInfo serverInfo = this.proxyServer.getServerInfo((String)connectionToServerName.getSecond());
        if (serverInfo != null) {
            player.connect(serverInfo);
        }
    }
}

