/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.external.org.spongepowered.configurate.serialize;

import app.simplecloud.external.io.leangen.geantyref.TypeToken;
import app.simplecloud.external.org.checkerframework.checker.nullness.qual.Nullable;
import app.simplecloud.external.org.spongepowered.configurate.BasicConfigurationNode;
import app.simplecloud.external.org.spongepowered.configurate.ConfigurationNode;
import app.simplecloud.external.org.spongepowered.configurate.ConfigurationOptions;
import app.simplecloud.external.org.spongepowered.configurate.serialize.SerializationException;
import app.simplecloud.external.org.spongepowered.configurate.serialize.TypeSerializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class MapSerializer
implements TypeSerializer<Map<?, ?>> {
    static final TypeToken<Map<?, ?>> TYPE = new TypeToken<Map<?, ?>>(){};

    MapSerializer() {
    }

    @Override
    public Map<?, ?> deserialize(Type type, ConfigurationNode node) throws SerializationException {
        LinkedHashMap ret2 = new LinkedHashMap();
        if (node.isMap()) {
            if (!(type instanceof ParameterizedType)) {
                throw new SerializationException(type, "Raw types are not supported for collections");
            }
            ParameterizedType param = (ParameterizedType)type;
            if (param.getActualTypeArguments().length != 2) {
                throw new SerializationException(type, "Map expected two type arguments!");
            }
            Type key = param.getActualTypeArguments()[0];
            Type value = param.getActualTypeArguments()[1];
            @Nullable TypeSerializer<?> keySerial = node.options().serializers().get(key);
            @Nullable TypeSerializer<?> valueSerial = node.options().serializers().get(value);
            if (keySerial == null) {
                throw new SerializationException(type, "No type serializer available for key type " + key);
            }
            if (valueSerial == null) {
                throw new SerializationException(type, "No type serializer available for value type " + value);
            }
            BasicConfigurationNode keyNode = BasicConfigurationNode.root(node.options());
            for (Map.Entry<Object, ? extends ConfigurationNode> ent : node.childrenMap().entrySet()) {
                ret2.put(Objects.requireNonNull(keySerial.deserialize(key, keyNode.set(ent.getKey())), "key"), Objects.requireNonNull(valueSerial.deserialize(value, ent.getValue()), "value"));
            }
        }
        return ret2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(Type type, @Nullable Map<?, ?> obj, ConfigurationNode node) throws SerializationException {
        if (!(type instanceof ParameterizedType)) {
            throw new SerializationException(type, "Raw types are not supported for collections");
        }
        ParameterizedType param = (ParameterizedType)type;
        if (param.getActualTypeArguments().length != 2) {
            throw new SerializationException(type, "Map expected two type arguments!");
        }
        Type key = param.getActualTypeArguments()[0];
        Type value = param.getActualTypeArguments()[1];
        @Nullable TypeSerializer<?> keySerial = node.options().serializers().get(key);
        @Nullable TypeSerializer<?> valueSerial = node.options().serializers().get(value);
        if (keySerial == null) {
            throw new SerializationException(type, "No type serializer available for key type " + key);
        }
        if (valueSerial == null) {
            throw new SerializationException(type, "No type serializer available for value type " + value);
        }
        if (obj == null || obj.isEmpty()) {
            node.set(Collections.emptyMap());
        } else {
            Set<Map.Entry<Object, Object>> unvisitedKeys;
            if (node.empty()) {
                node.raw(Collections.emptyMap());
                unvisitedKeys = Collections.emptySet();
            } else {
                unvisitedKeys = new HashSet<Object>(node.childrenMap().keySet());
            }
            BasicConfigurationNode keyNode = BasicConfigurationNode.root(node.options());
            for (Map.Entry<?, ?> ent : obj.entrySet()) {
                keySerial.serialize(key, ent.getKey(), keyNode);
                Object keyObj = Objects.requireNonNull(keyNode.raw(), "Key must not be null!");
                ConfigurationNode child = node.node(keyObj);
                try {
                    valueSerial.serialize(value, ent.getValue(), child);
                }
                catch (SerializationException ex) {
                    ex.initPath(child::path);
                }
                finally {
                    unvisitedKeys.remove(keyObj);
                }
            }
            for (Map.Entry<Object, Object> unusedChild : unvisitedKeys) {
                node.removeChild(unusedChild);
            }
        }
    }

    @Override
    public Map<?, ?> emptyValue(Type specificType, ConfigurationOptions options) {
        return new LinkedHashMap();
    }
}

