/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.connection.bungeecord;

import app.simplecloud.external.org.jetbrains.annotations.NotNull;
import app.simplecloud.plugin.connection.bungeecord.BungeeCordCommand;
import app.simplecloud.plugin.connection.bungeecord.ConnectionReconnectHandler;
import app.simplecloud.plugin.connection.shared.ConnectionAndTargetConfig;
import app.simplecloud.plugin.connection.shared.ServerConnectionPlugin;
import app.simplecloud.plugin.connection.shared.config.CommandConfig;
import app.simplecloud.plugin.connection.shared.server.ServerConnectionInfo;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ReconnectHandler;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ServerKickEvent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginManager;
import net.md_5.bungee.event.EventHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lapp/simplecloud/plugin/connection/bungeecord/BungeeCordServerConnectionPlugin;", "Lnet/md_5/bungee/api/plugin/Plugin;", "Lnet/md_5/bungee/api/plugin/Listener;", "<init>", "()V", "serverConnection", "Lapp/simplecloud/plugin/connection/shared/ServerConnectionPlugin;", "Lnet/md_5/bungee/api/connection/ProxiedPlayer;", "miniMessage", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "Lapp/simplecloud/external/org/jetbrains/annotations/NotNull;", "onLoad", "", "onEnable", "onServerKick", "event", "Lnet/md_5/bungee/api/event/ServerKickEvent;", "server-connection-plugin"})
@SourceDebugExtension(value={"SMAP\nBungeeCordServerConnectionPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BungeeCordServerConnectionPlugin.kt\napp/simplecloud/plugin/connection/bungeecord/BungeeCordServerConnectionPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,79:1\n1863#2,2:80\n126#3:82\n153#3,3:83\n*S KotlinDebug\n*F\n+ 1 BungeeCordServerConnectionPlugin.kt\napp/simplecloud/plugin/connection/bungeecord/BungeeCordServerConnectionPlugin\n*L\n45#1:80,2\n25#1:82\n25#1:83,3\n*E\n"})
public final class BungeeCordServerConnectionPlugin
extends Plugin
implements Listener {
    @NotNull
    private final ServerConnectionPlugin<ProxiedPlayer> serverConnection;
    @NotNull
    private final MiniMessage miniMessage;

    public BungeeCordServerConnectionPlugin() {
        Path path = this.getDataFolder().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        this.serverConnection = new ServerConnectionPlugin<ProxiedPlayer>(path, () -> BungeeCordServerConnectionPlugin.serverConnection$lambda$1(this), BungeeCordServerConnectionPlugin::serverConnection$lambda$2);
        MiniMessage miniMessage = MiniMessage.miniMessage();
        Intrinsics.checkNotNullExpressionValue((Object)miniMessage, (String)"miniMessage(...)");
        this.miniMessage = miniMessage;
    }

    public void onLoad() {
        ProxyServer proxyServer = this.getProxy();
        ProxyServer proxyServer2 = this.getProxy();
        Intrinsics.checkNotNullExpressionValue((Object)proxyServer2, (String)"getProxy(...)");
        proxyServer.setReconnectHandler((ReconnectHandler)new ConnectionReconnectHandler(this.serverConnection, proxyServer2));
    }

    public void onEnable() {
        PluginManager pluginManager = this.getProxy().getPluginManager();
        pluginManager.registerListener((Plugin)this, (Listener)this);
        Iterable $this$forEach$iv = this.serverConnection.getCommandConfigs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommandConfig it = (CommandConfig)element$iv;
            boolean bl = false;
            ProxyServer proxyServer = this.getProxy();
            Intrinsics.checkNotNullExpressionValue((Object)proxyServer, (String)"getProxy(...)");
            BungeeCordCommand bungeeCommand = new BungeeCordCommand(this.serverConnection, it, proxyServer, this.miniMessage);
            pluginManager.registerCommand((Plugin)this, (Command)bungeeCommand);
        }
    }

    @EventHandler
    public final void onServerKick(@NotNull ServerKickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isCancelled()) {
            return;
        }
        ProxiedPlayer proxiedPlayer = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)proxiedPlayer, (String)"getPlayer(...)");
        String string = event.getKickedFrom().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Pair<ConnectionAndTargetConfig, String> connectionAndTargetConfigToServerName = this.serverConnection.getConnectionAndNameForFallback(proxiedPlayer, string);
        if (connectionAndTargetConfigToServerName == null) {
            BaseComponent[] baseComponentArray = BungeeComponentSerializer.get().serialize((Component)this.miniMessage.deserialize(this.serverConnection.getConfig().getFallbackConnectionsConfig().getNoTargetConnectionFoundMessage()));
            event.setReason(TextComponent.fromArray((BaseComponent[])Arrays.copyOf(baseComponentArray, baseComponentArray.length)));
            event.setCancelServer(null);
            event.setCancelled(true);
            return;
        }
        ServerInfo serverInfo = this.getProxy().getServerInfo((String)connectionAndTargetConfigToServerName.getSecond());
        if (serverInfo == null) {
            return;
        }
        ServerInfo serverInfo2 = serverInfo;
        event.setCancelled(true);
        event.setCancelServer(serverInfo2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List serverConnection$lambda$1(BungeeCordServerConnectionPlugin this$0) {
        void $this$mapTo$iv$iv;
        Map map2 = this$0.getProxy().getServers();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getServers(...)");
        Map $this$map$iv = map2;
        boolean $i$f$map = false;
        Map map3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            collection.add(new ServerConnectionInfo((String)k, ((ServerInfo)it.getValue()).getPlayers().size()));
        }
        return (List)destination$iv$iv;
    }

    private static final boolean serverConnection$lambda$2(ProxiedPlayer player, String permission) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        return player.hasPermission(permission);
    }
}

