/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.connection.shared;

import app.simplecloud.external.org.jetbrains.annotations.NotNull;
import app.simplecloud.external.org.jetbrains.annotations.Nullable;
import app.simplecloud.plugin.api.shared.matcher.ServerMatcherConfiguration;
import app.simplecloud.plugin.connection.shared.ConnectionAndTargetConfig;
import app.simplecloud.plugin.connection.shared.PermissionChecker;
import app.simplecloud.plugin.connection.shared.config.CommandConfig;
import app.simplecloud.plugin.connection.shared.config.Config;
import app.simplecloud.plugin.connection.shared.config.ConfigFactory;
import app.simplecloud.plugin.connection.shared.config.ConnectionConfig;
import app.simplecloud.plugin.connection.shared.config.RulesConfig;
import app.simplecloud.plugin.connection.shared.config.TargetConnectionConfig;
import app.simplecloud.plugin.connection.shared.server.ServerConnectionInfo;
import app.simplecloud.plugin.connection.shared.server.ServerConnectionInfoGetter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\t\u0010\nJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0015\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J!\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J)\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u001cJ)\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u001fJ;\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00028\u00002\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00102\b\b\u0002\u0010\u001b\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010#J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\u001b\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00102\u0006\u0010\u0014\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010)J\u001a\u0010*\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010+\u001a\u00020(H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006,"}, d2={"Lapp/simplecloud/plugin/connection/shared/ServerConnectionPlugin;", "P", "", "dataDirectory", "Ljava/nio/file/Path;", "serverConnectionInfoGetter", "Lapp/simplecloud/plugin/connection/shared/server/ServerConnectionInfoGetter;", "permissionChecker", "Lapp/simplecloud/plugin/connection/shared/PermissionChecker;", "<init>", "(Ljava/nio/file/Path;Lapp/simplecloud/plugin/connection/shared/server/ServerConnectionInfoGetter;Lapp/simplecloud/plugin/connection/shared/PermissionChecker;)V", "config", "Lapp/simplecloud/plugin/connection/shared/config/Config;", "getConfig", "()Lapp/simplecloud/plugin/connection/shared/config/Config;", "getCommandConfigs", "", "Lapp/simplecloud/plugin/connection/shared/config/CommandConfig;", "getServerNameForLogin", "", "player", "(Ljava/lang/Object;)Ljava/lang/String;", "getConnectionAndNameForLogin", "Lkotlin/Pair;", "Lapp/simplecloud/plugin/connection/shared/ConnectionAndTargetConfig;", "(Ljava/lang/Object;)Lkotlin/Pair;", "getConnectionAndNameForFallback", "fromServerName", "(Ljava/lang/Object;Ljava/lang/String;)Lkotlin/Pair;", "getConnectionAndNameForCommand", "commandConfig", "(Ljava/lang/Object;Lapp/simplecloud/plugin/connection/shared/config/CommandConfig;)Lkotlin/Pair;", "getConnectionAndName", "targetConnections", "Lapp/simplecloud/plugin/connection/shared/config/TargetConnectionConfig;", "(Ljava/lang/Object;Ljava/util/List;Ljava/lang/String;)Lkotlin/Pair;", "matchesTargetConnection", "", "targetConnectionConfig", "getPossibleServerConnections", "Lapp/simplecloud/plugin/connection/shared/config/ConnectionConfig;", "(Ljava/lang/Object;)Ljava/util/List;", "getBestServerToConnect", "bestConnection", "server-connection-plugin"})
@SourceDebugExtension(value={"SMAP\nServerConnectionPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerConnectionPlugin.kt\napp/simplecloud/plugin/connection/shared/ServerConnectionPlugin\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1437#2,14:84\n183#2,2:117\n1755#3,3:98\n1557#3:101\n1628#3,3:102\n774#3:105\n865#3:106\n1734#3,3:107\n866#3:110\n774#3:111\n865#3,2:112\n1053#3:114\n295#3,2:115\n*S KotlinDebug\n*F\n+ 1 ServerConnectionPlugin.kt\napp/simplecloud/plugin/connection/shared/ServerConnectionPlugin\n*L\n48#1:84,14\n44#1:117,2\n59#1:98,3\n66#1:101\n66#1:102,3\n68#1:105\n68#1:106\n70#1:107,3\n68#1:110\n77#1:111\n77#1:112,2\n78#1:114\n79#1:115,2\n*E\n"})
public final class ServerConnectionPlugin<P> {
    @NotNull
    private final Path dataDirectory;
    @NotNull
    private final ServerConnectionInfoGetter serverConnectionInfoGetter;
    @NotNull
    private final PermissionChecker<P> permissionChecker;
    @NotNull
    private final Config config;

    public ServerConnectionPlugin(@NotNull Path dataDirectory, @NotNull ServerConnectionInfoGetter serverConnectionInfoGetter, @NotNull PermissionChecker<P> permissionChecker) {
        Intrinsics.checkNotNullParameter((Object)dataDirectory, (String)"dataDirectory");
        Intrinsics.checkNotNullParameter((Object)serverConnectionInfoGetter, (String)"serverConnectionInfoGetter");
        Intrinsics.checkNotNullParameter(permissionChecker, (String)"permissionChecker");
        this.dataDirectory = dataDirectory;
        this.serverConnectionInfoGetter = serverConnectionInfoGetter;
        this.permissionChecker = permissionChecker;
        this.config = ConfigFactory.INSTANCE.loadOrCreate(this.dataDirectory);
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    @NotNull
    public final List<CommandConfig> getCommandConfigs() {
        return this.config.getCommands();
    }

    @Nullable
    public final String getServerNameForLogin(P player) {
        Pair<ConnectionAndTargetConfig, String> pair = this.getConnectionAndNameForLogin(player);
        return pair != null ? (String)pair.getSecond() : null;
    }

    @Nullable
    public final Pair<ConnectionAndTargetConfig, String> getConnectionAndNameForLogin(P player) {
        return ServerConnectionPlugin.getConnectionAndName$default(this, player, this.config.getNetworkJoinTargets().getTargetConnections(), null, 4, null);
    }

    @Nullable
    public final Pair<ConnectionAndTargetConfig, String> getConnectionAndNameForFallback(P player, @NotNull String fromServerName) {
        Intrinsics.checkNotNullParameter((Object)fromServerName, (String)"fromServerName");
        return this.getConnectionAndName(player, this.config.getFallbackConnectionsConfig().getTargetConnections(), fromServerName);
    }

    @Nullable
    public final Pair<ConnectionAndTargetConfig, String> getConnectionAndNameForCommand(P player, @NotNull CommandConfig commandConfig) {
        Intrinsics.checkNotNullParameter((Object)commandConfig, (String)"commandConfig");
        return ServerConnectionPlugin.getConnectionAndName$default(this, player, commandConfig.getTargetConnections(), null, 4, null);
    }

    private final Pair<ConnectionAndTargetConfig, String> getConnectionAndName(P player, List<TargetConnectionConfig> targetConnections, String fromServerName) {
        Object v0;
        Sequence possibleConnectionsWithTarget;
        List<ConnectionConfig> possibleConnections = this.getPossibleServerConnections(player);
        Sequence filteredTargetConnections = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)targetConnections), arg_0 -> ServerConnectionPlugin.getConnectionAndName$lambda$0(fromServerName, this, arg_0));
        Sequence $this$maxByOrNull$iv = possibleConnectionsWithTarget = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)possibleConnections), arg_0 -> ServerConnectionPlugin.getConnectionAndName$lambda$2(filteredTargetConnections, arg_0));
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                ConnectionAndTargetConfig it = (ConnectionAndTargetConfig)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getTargetConfig().getPriority();
                do {
                    Object e$iv = iterator$iv.next();
                    ConnectionAndTargetConfig it2 = (ConnectionAndTargetConfig)e$iv;
                    $i$a$-maxByOrNull-ServerConnectionPlugin$getConnectionAndName$connectionAndTargetConfig$1 = false;
                    int v$iv = it2.getTargetConfig().getPriority();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        ConnectionAndTargetConfig connectionAndTargetConfig = v0;
        if (connectionAndTargetConfig == null) {
            return null;
        }
        ConnectionAndTargetConfig connectionAndTargetConfig2 = connectionAndTargetConfig;
        String string = this.getBestServerToConnect(fromServerName, connectionAndTargetConfig2.getConnectionConfig());
        if (string == null) {
            return null;
        }
        String bestServerToConnect = string;
        return new Pair((Object)connectionAndTargetConfig2, (Object)bestServerToConnect);
    }

    static /* synthetic */ Pair getConnectionAndName$default(ServerConnectionPlugin serverConnectionPlugin, Object object, List list, String string, int n, Object object2) {
        if ((n & 4) != 0) {
            string = "";
        }
        return serverConnectionPlugin.getConnectionAndName(object, list, string);
    }

    private final boolean matchesTargetConnection(TargetConnectionConfig targetConnectionConfig, String fromServerName) {
        boolean bl;
        block4: {
            if (targetConnectionConfig.getFrom().isEmpty()) {
                return true;
            }
            Iterable $this$any$iv = targetConnectionConfig.getFrom();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ServerMatcherConfiguration it = (ServerMatcherConfiguration)element$iv;
                    boolean bl2 = false;
                    if (!it.matches(fromServerName)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private final List<ConnectionConfig> getPossibleServerConnections(P player) {
        serverConnectionInfos = this.serverConnectionInfoGetter.get();
        $this$map$iv = serverConnectionInfos;
        $i$f$map = false;
        var6_5 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var11_10 = (ServerConnectionInfo)item$iv$iv;
            var19_12 = destination$iv$iv;
            $i$a$-map-ServerConnectionPlugin$getPossibleServerConnections$serverNames$1 = false;
            var19_12.add(it.getName());
        }
        serverNames = (List)destination$iv$iv;
        $this$filter$iv = this.config.getConnections();
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block7: {
                connection = (ConnectionConfig)element$iv$iv;
                $i$a$-filter-ServerConnectionPlugin$getPossibleServerConnections$1 = false;
                if (!connection.getServerNameMatcher().anyMatches(serverNames)) ** GOTO lbl-1000
                $this$all$iv = connection.getRules();
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v0 = true;
                } else {
                    for (T element$iv : $this$all$iv) {
                        it = (RulesConfig)element$iv;
                        $i$a$-all-ServerConnectionPlugin$getPossibleServerConnections$1$1 = false;
                        if (it.isAllowed(player, this.permissionChecker)) continue;
                        v0 = false;
                        break block7;
                    }
                    v0 = true;
                }
            }
            if (v0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final String getBestServerToConnect(String fromServerName, ConnectionConfig bestConnection) {
        ServerConnectionInfo bestServer;
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            Iterable $this$sortedBy$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            List<ServerConnectionInfo> serverConnectionInfos = this.serverConnectionInfoGetter.get();
            Iterable iterable = serverConnectionInfos;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ServerConnectionInfo it = (ServerConnectionInfo)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getName(), (Object)fromServerName))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ServerConnectionInfo it = (ServerConnectionInfo)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getOnlinePlayers());
                    it = (ServerConnectionInfo)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOnlinePlayers()));
                }
            });
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ServerConnectionInfo it = (ServerConnectionInfo)element$iv;
                boolean bl = false;
                if (!bestConnection.getServerNameMatcher().matches(it.getName())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        ServerConnectionInfo serverConnectionInfo = bestServer = (ServerConnectionInfo)v0;
        return serverConnectionInfo != null ? serverConnectionInfo.getName() : null;
    }

    private static final boolean getConnectionAndName$lambda$0(String $fromServerName, ServerConnectionPlugin this$0, TargetConnectionConfig it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.isBlank((CharSequence)$fromServerName) || this$0.matchesTargetConnection(it, $fromServerName);
    }

    private static final ConnectionAndTargetConfig getConnectionAndName$lambda$2(Sequence $filteredTargetConnections, ConnectionConfig possibleConnection) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)possibleConnection, (String)"possibleConnection");
            Sequence $this$firstOrNull$iv = $filteredTargetConnections;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TargetConnectionConfig it = (TargetConnectionConfig)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)possibleConnection.getName(), (Object)it.getName())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        TargetConnectionConfig targetConnectionConfig = v0;
        if (targetConnectionConfig == null) {
            return null;
        }
        TargetConnectionConfig targetConfig = targetConnectionConfig;
        return new ConnectionAndTargetConfig(possibleConnection, targetConfig);
    }
}

