/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.serializer.legacy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextFormat;
import net.kyori.adventure.text.serializer.legacy.CharacterAndFormat;

final class CharacterAndFormatSet {
    static final CharacterAndFormatSet DEFAULT = CharacterAndFormatSet.of(CharacterAndFormat.defaults());
    final List<TextFormat> formats;
    final List<TextColor> colors;
    final String characters;

    static CharacterAndFormatSet of(List<CharacterAndFormat> pairs) {
        int size = pairs.size();
        ArrayList<TextColor> colors = new ArrayList<TextColor>();
        ArrayList<TextFormat> formats = new ArrayList<TextFormat>(size);
        StringBuilder characters = new StringBuilder(size);
        for (int i2 = 0; i2 < size; ++i2) {
            CharacterAndFormat pair = pairs.get(i2);
            characters.append(pair.character());
            TextFormat format = pair.format();
            formats.add(format);
            if (!(format instanceof TextColor)) continue;
            colors.add((TextColor)format);
        }
        if (formats.size() != characters.length()) {
            throw new IllegalStateException("formats length differs from characters length");
        }
        return new CharacterAndFormatSet(Collections.unmodifiableList(formats), Collections.unmodifiableList(colors), characters.toString());
    }

    CharacterAndFormatSet(List<TextFormat> formats, List<TextColor> colors, String characters) {
        this.formats = formats;
        this.colors = colors;
        this.characters = characters;
    }
}

