/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads;

import net.blay09.mods.balm.api.event.CropGrowEvent;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheadsConfig;
import net.blay09.mods.farmingforblockheads.block.FertilizedFarmlandBlock;
import net.blay09.mods.farmingforblockheads.tag.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FarmlandHandler {
    public static void onGrowEvent(CropGrowEvent.Post event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState plant = level.getBlockState(event.getPos());
        Block block = plant.getBlock();
        if (block instanceof BonemealableBlock) {
            BonemealableBlock growable = (BonemealableBlock)block;
            BlockState farmland = level.getBlockState(event.getPos().below());
            if (farmland.is(ModBlockTags.HEALTHY_FARMLAND)) {
                float doubleGrowthChance = (float)FarmingForBlockheadsConfig.getActive().fertilizerBonusGrowthChance;
                if (Math.random() <= (double)doubleGrowthChance && growable.isValidBonemealTarget((LevelReader)level, pos, plant)) {
                    growable.performBonemeal((ServerLevel)level, level.getRandom(), pos, plant);
                    level.levelEvent(2005, pos, 0);
                    FarmlandHandler.rollRegression(level, pos.below(), farmland);
                }
            }
        }
    }

    public static void rollRegression(Level level, BlockPos pos, BlockState farmland) {
        if (farmland.getBlock() instanceof FertilizedFarmlandBlock && Math.random() <= (double)((FertilizedFarmlandBlock)farmland.getBlock()).getRegressionChance()) {
            level.setBlockAndUpdate(pos, (BlockState)Blocks.FARMLAND.defaultBlockState().setValue((Property)FarmBlock.MOISTURE, (Comparable)((Integer)farmland.getValue((Property)FarmBlock.MOISTURE))));
        }
    }
}

