/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.client.gui.widget;

import net.blay09.mods.farmingforblockheads.api.MarketCategory;
import net.blay09.mods.farmingforblockheads.menu.MarketMenu;
import net.blay09.mods.farmingforblockheads.registry.SimpleHolder;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class MarketFilterButton
extends Button {
    private static final ResourceLocation ICONS = ResourceLocation.fromNamespaceAndPath((String)"farmingforblockheads", (String)"textures/gui/market.png");
    private final MarketMenu menu;
    private final SimpleHolder<MarketCategory> category;

    public MarketFilterButton(int x, int y, MarketMenu menu, SimpleHolder<MarketCategory> category, Button.OnPress pressable) {
        super(x, y, 20, 20, (Component)Component.empty(), pressable, Button.DEFAULT_NARRATION);
        this.menu = menu;
        this.category = category;
        this.setTooltip(Tooltip.create((Component)category.value().tooltip()));
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
        int texY = 14;
        if (this.menu.getCurrentCategory().map(it -> !it.equals(this.category)).orElse(false).booleanValue()) {
            texY += 40;
        } else if (this.isHovered) {
            texY += 20;
        }
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ICONS, this.getX(), this.getY(), 176.0f, (float)texY, this.width, this.height, 256, 256);
        guiGraphics.renderItem(this.category.value().iconStack(), this.getX() + 2, this.getY() + 2);
    }

    public SimpleHolder<MarketCategory> getCategory() {
        return this.category;
    }
}

