/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.blay09.mods.farmingforblockheads.block.ChickenNestBlock;
import net.blay09.mods.farmingforblockheads.block.entity.ChickenNestBlockEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class ChickenNestRenderer
implements BlockEntityRenderer<ChickenNestBlockEntity, ChickenNestRenderState> {
    private final ItemStack EGG_STACK = new ItemStack((ItemLike)Items.EGG);
    private final float[] EGG_POSITIONS = new float[]{0.2f, 0.0f, 0.0f, -0.2f, 0.0f, 0.0f, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.1f};
    private final ItemModelResolver itemModelResolver;

    public ChickenNestRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public ChickenNestRenderState createRenderState() {
        return new ChickenNestRenderState();
    }

    public void extractRenderState(ChickenNestBlockEntity blockEntity, ChickenNestRenderState renderState, float delta, Vec3 vec, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        BlockEntityRenderState.extractBase((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        renderState.facing = (Direction)renderState.blockState.getValue(ChickenNestBlock.FACING);
        renderState.count = blockEntity.getEggCount();
        this.itemModelResolver.updateForTopItem(renderState.item, this.EGG_STACK, ItemDisplayContext.FIXED, blockEntity.getLevel(), null, (int)renderState.blockPos.asLong());
    }

    public void submit(ChickenNestRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.facing.toYRot()));
        for (int i = 0; i < Math.min(this.EGG_POSITIONS.length / 3, renderState.count); ++i) {
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.2f, 0.0f);
            poseStack.translate(this.EGG_POSITIONS[i * 3], this.EGG_POSITIONS[i * 3 + 1], this.EGG_POSITIONS[i * 3 + 2]);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(45.0f));
            float scale = 0.5f;
            poseStack.scale(0.5f, 0.5f, 0.5f);
            renderState.item.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
    }

    public static class ChickenNestRenderState
    extends BlockEntityRenderState {
        public Direction facing = Direction.NORTH;
        public final ItemStackRenderState item = new ItemStackRenderState();
        public int count;
    }
}

