/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.menu;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.farmingforblockheads.api.MarketCategory;
import net.blay09.mods.farmingforblockheads.api.Payment;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.blay09.mods.farmingforblockheads.menu.MarketListingSlot;
import net.blay09.mods.farmingforblockheads.menu.MarketPaymentContainer;
import net.blay09.mods.farmingforblockheads.menu.MarketPaymentSlot;
import net.blay09.mods.farmingforblockheads.menu.MarketResultContainer;
import net.blay09.mods.farmingforblockheads.menu.MarketResultSlot;
import net.blay09.mods.farmingforblockheads.menu.ModMenus;
import net.blay09.mods.farmingforblockheads.menu.ServerPlaceMarketRecipe;
import net.blay09.mods.farmingforblockheads.network.MarketPlaceRecipeMessage;
import net.blay09.mods.farmingforblockheads.recipe.MarketRecipe;
import net.blay09.mods.farmingforblockheads.recipe.MarketRecipeDisplay;
import net.blay09.mods.farmingforblockheads.recipe.ModRecipes;
import net.blay09.mods.farmingforblockheads.registry.MarketDefaultsRegistry;
import net.blay09.mods.farmingforblockheads.registry.PaymentImpl;
import net.blay09.mods.farmingforblockheads.registry.SimpleHolder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class MarketMenu
extends AbstractContainerMenu {
    private static final int PAYMENT_SLOT = 0;
    private static final int RESULT_SLOT = 1;
    private static final int LISTING_SLOT_START = 2;
    private static final int LISTING_SLOT_END = 14;
    private static final int INV_SLOT_START = 14;
    private static final int INV_SLOT_END = 41;
    private static final int USE_ROW_SLOT_START = 41;
    private static final int USE_ROW_SLOT_END = 50;
    private final ContainerLevelAccess access;
    private final Player player;
    private boolean placingRecipe;
    private final MarketPaymentContainer paymentSlots = new MarketPaymentContainer(this, 1);
    private final MarketResultContainer resultSlots = new MarketResultContainer();
    private final List<MarketListingSlot> listingSlots = new ArrayList<MarketListingSlot>();
    private List<SimpleHolder<MarketCategory>> categories = List.of();
    private List<RecipeDisplayEntry> recipes = List.of();
    private String currentSearch;
    private SimpleHolder<MarketCategory> currentCategory;
    private boolean scrollOffsetDirty;
    private int scrollOffset;
    private final List<RecipeDisplayEntry> filteredRecipes = new ArrayList<RecipeDisplayEntry>();
    private RecipeDisplayEntry selectedRecipeDisplayEntry;
    private RecipeHolder<MarketRecipe> serverSelectedRecipe;

    public MarketMenu(int windowId, Inventory playerInventory, ContainerLevelAccess access) {
        super((MenuType)ModMenus.market.get(), windowId);
        this.access = access;
        this.player = playerInventory.player;
        this.addSlot(new MarketPaymentSlot((Container)this.paymentSlots, 0, 23, 39));
        this.addSlot(new MarketResultSlot(this.player, this.paymentSlots, (Container)this.resultSlots, 0, 61, 39));
        DefaultContainer fakeInventory = new DefaultContainer(12);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 3; ++j) {
                MarketListingSlot slot = new MarketListingSlot((Container)fakeInventory, j + i * 3, 102 + j * 18, 11 + i * 18, this.player.level());
                this.listingSlots.add(slot);
                this.addSlot(slot);
            }
        }
        this.addStandardInventorySlots((Container)playerInventory, 8, 92);
    }

    protected static void slotChangedMarket(AbstractContainerMenu menu, ServerLevel level, Player player, MarketPaymentContainer container, ResultContainer resultContainer, @Nullable RecipeHolder<MarketRecipe> recipeHolder) {
        RecipeInput recipeInput = container.asRecipeInput();
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ItemStack resultItem = ItemStack.EMPTY;
        Optional foundRecipe = level.getServer().getRecipeManager().getRecipeFor(ModRecipes.marketRecipeType, recipeInput, (Level)level, recipeHolder);
        if (foundRecipe.isPresent()) {
            ItemStack assembledStack;
            RecipeHolder foundRecipeHolder = (RecipeHolder)foundRecipe.get();
            MarketRecipe recipe = (MarketRecipe)foundRecipeHolder.value();
            if (resultContainer.setRecipeUsed(serverPlayer, foundRecipeHolder) && (assembledStack = recipe.assemble(recipeInput, (HolderLookup.Provider)level.registryAccess())).isItemEnabled(level.enabledFeatures())) {
                resultItem = assembledStack;
            }
        }
        resultContainer.setItem(0, resultItem);
        menu.setRemoteSlot(1, resultItem);
        serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(menu.containerId, menu.incrementStateId(), 1, resultItem));
    }

    public void slotsChanged(Container pContainer) {
        if (!this.placingRecipe) {
            this.access.execute((level, pos) -> {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    MarketMenu.slotChangedMarket(this, serverLevel, this.player, this.paymentSlots, this.resultSlots, this.serverSelectedRecipe);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecipeBookMenu.PostPlaceAction handlePlacement(boolean useMaxItems, boolean creative, RecipeHolder<?> genericRecipeHolder, ServerLevel level, Inventory inventory) {
        RecipeBookMenu.PostPlaceAction postPlaceAction;
        RecipeHolder<?> recipeHolder = genericRecipeHolder;
        this.beginPlacingRecipe();
        if (this.serverSelectedRecipe != recipeHolder) {
            this.clearContainer(this.player, (Container)this.paymentSlots);
        }
        try {
            postPlaceAction = ServerPlaceMarketRecipe.placeRecipe(new ServerPlaceRecipe.CraftingMenuAccess<MarketRecipe>(){

                public void fillCraftSlotsStackedContents(StackedItemContents stackedItemContents) {
                    MarketMenu.this.fillPaymentSlotsStackedContents(stackedItemContents);
                }

                public void clearCraftingContent() {
                    MarketMenu.this.resultSlots.clearContent();
                    MarketMenu.this.paymentSlots.clearContent();
                }

                public boolean recipeMatches(RecipeHolder<MarketRecipe> recipe) {
                    return ((MarketRecipe)recipe.value()).matches(MarketMenu.this.paymentSlots.asRecipeInput(), MarketMenu.this.owner().level());
                }
            }, this.getPaymentSlot(), inventory, recipeHolder, useMaxItems, creative);
        }
        finally {
            this.finishPlacingRecipe(level, recipeHolder);
        }
        return postPlaceAction;
    }

    private void fillPaymentSlotsStackedContents(StackedItemContents stackedItemContents) {
        this.paymentSlots.fillStackedContents(stackedItemContents);
    }

    public void beginPlacingRecipe() {
        this.placingRecipe = true;
    }

    public void finishPlacingRecipe(ServerLevel level, RecipeHolder<MarketRecipe> recipeHolder) {
        this.placingRecipe = false;
        this.serverSelectedRecipe = recipeHolder;
        MarketMenu.slotChangedMarket(this, level, this.player, this.paymentSlots, this.resultSlots, recipeHolder);
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.clearContainer(this.player, (Container)this.paymentSlots);
    }

    public boolean stillValid(Player player) {
        return MarketMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)ModBlocks.market);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (index == 1) {
                if (!this.moveItemStackTo(slotStack, 14, 50, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, itemStack);
            } else if (index == 0 ? !this.moveItemStackTo(slotStack, 14, 50, true) : (this.isPayment(slotStack) ? !this.moveItemStackTo(slotStack, 0, 1, true) : (index >= 41 && index < 50 ? !this.moveItemStackTo(slotStack, 14, 41, true) : index >= 14 && index < 41 && !this.moveItemStackTo(slotStack, 41, 50, false)))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return itemStack;
    }

    private boolean isPayment(ItemStack itemStack) {
        RecipeDisplay recipeDisplay;
        if (this.selectedRecipeDisplayEntry != null && (recipeDisplay = this.selectedRecipeDisplayEntry.display()) instanceof MarketRecipeDisplay) {
            MarketRecipeDisplay marketRecipeDisplay = (MarketRecipeDisplay)recipeDisplay;
            ContextMap contextMap = SlotDisplayContext.fromLevel((Level)this.player.level());
            List paymentStacks = marketRecipeDisplay.payment().resolveForStacks(contextMap);
            for (ItemStack paymentStack : paymentStacks) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)paymentStack, (ItemStack)itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canTakeItemForPickAll(ItemStack itemStack, Slot slot) {
        return slot.container != this.resultSlots && super.canTakeItemForPickAll(itemStack, slot);
    }

    public Slot getPaymentSlot() {
        return (Slot)this.slots.get(0);
    }

    public Slot getResultSlot() {
        return (Slot)this.slots.get(1);
    }

    protected Player owner() {
        return this.player;
    }

    public void clicked(int slotNumber, int dragType, ClickType clickType, Player player) {
        if (slotNumber >= 0 && slotNumber < this.slots.size()) {
            MarketListingSlot listingSlot;
            RecipeDisplayEntry recipe;
            Slot slot = (Slot)this.slots.get(slotNumber);
            if (player.level().isClientSide() && clickType != ClickType.PICKUP_ALL && slot instanceof MarketListingSlot && (recipe = (listingSlot = (MarketListingSlot)slot).getRecipeDisplayEntry()) != null) {
                this.selectedRecipeDisplayEntry = recipe;
                Balm.getNetworking().sendToServer((CustomPacketPayload)new MarketPlaceRecipeMessage(this.containerId, recipe.id(), clickType == ClickType.QUICK_MOVE));
            }
        }
        super.clicked(slotNumber, dragType, clickType, player);
    }

    public void setSearch(@Nullable String term) {
        this.currentSearch = term;
        this.updateFilteredRecipes();
        this.setScrollOffset(0);
    }

    public void setCategory(@Nullable SimpleHolder<MarketCategory> category) {
        this.currentCategory = category;
        this.updateFilteredRecipes();
        this.setScrollOffset(0);
    }

    private void updateFilteredRecipes() {
        this.filteredRecipes.clear();
        for (RecipeDisplayEntry recipe : this.recipes) {
            if (!this.searchMatches(recipe) || !this.categoryMatches(recipe)) continue;
            this.filteredRecipes.add(recipe);
        }
        this.filteredRecipes.sort(this.sorting());
    }

    private boolean searchMatches(RecipeDisplayEntry recipeDisplayEntry) {
        if (this.currentSearch == null || this.currentSearch.trim().isEmpty()) {
            return true;
        }
        ContextMap contextMap = SlotDisplayContext.fromLevel((Level)this.player.level());
        ItemStack resultItem = recipeDisplayEntry.display().result().resolveForFirstStack(contextMap);
        String lowerCaseSearch = this.currentSearch.toLowerCase();
        if (resultItem.getDisplayName().getString().toLowerCase(Locale.ENGLISH).contains(lowerCaseSearch)) {
            return true;
        }
        List tooltips = resultItem.getTooltipLines(Item.TooltipContext.EMPTY, this.player, (TooltipFlag)TooltipFlag.Default.NORMAL);
        for (Component tooltip : tooltips) {
            if (!tooltip.getString().toLowerCase(Locale.ENGLISH).contains(lowerCaseSearch)) continue;
            return true;
        }
        return false;
    }

    private boolean categoryMatches(RecipeDisplayEntry recipeDisplayEntry) {
        if (this.currentCategory == null) {
            return true;
        }
        RecipeDisplay display = recipeDisplayEntry.display();
        if (display instanceof MarketRecipeDisplay) {
            MarketRecipeDisplay marketRecipeDisplay = (MarketRecipeDisplay)display;
            ResourceLocation marketCategory = marketRecipeDisplay.category();
            return marketCategory.equals((Object)this.currentCategory.id());
        }
        return true;
    }

    public int getFilteredListCount() {
        return this.filteredRecipes.size();
    }

    public void setScrollOffset(int scrollOffset) {
        this.scrollOffset = scrollOffset;
        this.updateListingSlots();
    }

    public void updateListingSlots() {
        int i = this.scrollOffset * 3;
        for (MarketListingSlot slot : this.listingSlots) {
            if (i < this.filteredRecipes.size()) {
                slot.setRecipeDisplayEntry(this.filteredRecipes.get(i));
                ++i;
                continue;
            }
            slot.setRecipeDisplayEntry(null);
        }
    }

    public boolean isScrollOffsetDirty() {
        return this.scrollOffsetDirty;
    }

    public void setScrollOffsetDirty(boolean scrollOffsetDirty) {
        this.scrollOffsetDirty = scrollOffsetDirty;
    }

    public Optional<SimpleHolder<MarketCategory>> getCurrentCategory() {
        return Optional.ofNullable(this.currentCategory);
    }

    public List<SimpleHolder<MarketCategory>> getCategories() {
        return this.categories;
    }

    public void setRecipes(List<RecipeDisplayEntry> recipes) {
        this.recipes = recipes;
        this.updateFilteredRecipes();
        this.setScrollOffset(0);
    }

    public void setCategories(List<SimpleHolder<MarketCategory>> categories) {
        this.categories = categories;
        this.setScrollOffsetDirty(true);
    }

    private Optional<MarketCategory> resolveMarketCategory(ResourceLocation identifier) {
        return this.categories.stream().filter(it -> it.id().equals((Object)identifier)).findFirst().map(SimpleHolder::value);
    }

    private Comparator<RecipeDisplayEntry> sorting() {
        ContextMap contextMap = SlotDisplayContext.fromLevel((Level)this.player.level());
        return Comparator.comparingInt(recipe -> {
            int n;
            RecipeDisplay patt0$temp = recipe.display();
            if (patt0$temp instanceof MarketRecipeDisplay) {
                MarketRecipeDisplay marketRecipeDisplay = (MarketRecipeDisplay)patt0$temp;
                n = this.resolveMarketCategory(marketRecipeDisplay.category()).map(MarketCategory::sortIndex).orElse(0);
            } else {
                n = 0;
            }
            return n;
        }).thenComparing(recipe -> {
            Integer n;
            RecipeDisplay patt0$temp = recipe.display();
            if (patt0$temp instanceof MarketRecipeDisplay) {
                MarketRecipeDisplay marketRecipeDisplay = (MarketRecipeDisplay)patt0$temp;
                n = marketRecipeDisplay.sortIndex();
            } else {
                n = 0;
            }
            return n;
        }).thenComparing(recipe -> {
            ItemStack itemStack;
            RecipeDisplay patt0$temp = recipe.display();
            if (patt0$temp instanceof MarketRecipeDisplay) {
                MarketRecipeDisplay marketRecipeDisplay = (MarketRecipeDisplay)patt0$temp;
                itemStack = marketRecipeDisplay.icon().resolveForFirstStack(contextMap);
            } else {
                itemStack = recipe.display().result().resolveForFirstStack(contextMap);
            }
            return itemStack.getDisplayName().getString();
        });
    }

    public boolean containsRecipeDisplayId(RecipeDisplayId recipeDisplayId) {
        return this.recipes.stream().anyMatch(it -> it.id().equals((Object)recipeDisplayId));
    }

    public Optional<Payment> getExpectedPayment() {
        RecipeDisplay recipeDisplay;
        if (this.serverSelectedRecipe != null) {
            return Optional.of(MarketDefaultsRegistry.resolvePayment((MarketRecipe)this.serverSelectedRecipe.value()));
        }
        if (this.selectedRecipeDisplayEntry != null && (recipeDisplay = this.selectedRecipeDisplayEntry.display()) instanceof MarketRecipeDisplay) {
            MarketRecipeDisplay marketRecipeDisplay = (MarketRecipeDisplay)recipeDisplay;
            ContextMap contextMap = SlotDisplayContext.fromLevel((Level)this.player.level());
            List paymentItems = marketRecipeDisplay.payment().resolveForStacks(contextMap);
            Ingredient ingredient = Ingredient.of(paymentItems.stream().map(ItemStack::getItem));
            return Optional.of(new PaymentImpl(ingredient, 0, Optional.empty()));
        }
        return Optional.empty();
    }
}

