/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.menu;

import java.util.ArrayList;
import net.blay09.mods.farmingforblockheads.api.Payment;
import net.blay09.mods.farmingforblockheads.recipe.MarketRecipe;
import net.blay09.mods.farmingforblockheads.registry.MarketDefaultsRegistry;
import net.minecraft.core.Holder;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class ServerPlaceMarketRecipe {
    private final ServerPlaceRecipe.CraftingMenuAccess<MarketRecipe> menuAccess;
    private final Slot paymentSlot;
    private final Inventory inventory;
    private final RecipeHolder<MarketRecipe> recipeHolder;
    private final boolean useMaxItems;
    private final boolean creative;

    public ServerPlaceMarketRecipe(ServerPlaceRecipe.CraftingMenuAccess<MarketRecipe> menuAccess, Slot paymentSlot, Inventory inventory, RecipeHolder<MarketRecipe> recipeHolder, boolean useMaxItems, boolean creative) {
        this.menuAccess = menuAccess;
        this.paymentSlot = paymentSlot;
        this.recipeHolder = recipeHolder;
        this.inventory = inventory;
        this.useMaxItems = useMaxItems;
        this.creative = creative;
    }

    public static RecipeBookMenu.PostPlaceAction placeRecipe(ServerPlaceRecipe.CraftingMenuAccess<MarketRecipe> access, Slot paymentSlot, Inventory inventory, RecipeHolder<MarketRecipe> recipeHolder, boolean useMaxItems, boolean creative) {
        ServerPlaceMarketRecipe serverPlaceMarketRecipe = new ServerPlaceMarketRecipe(access, paymentSlot, inventory, recipeHolder, useMaxItems, creative);
        if (!creative && !serverPlaceMarketRecipe.testClearPayment()) {
            return RecipeBookMenu.PostPlaceAction.NOTHING;
        }
        StackedItemContents stackedItemContents = new StackedItemContents();
        inventory.fillStackedContents(stackedItemContents);
        access.fillCraftSlotsStackedContents(stackedItemContents);
        return serverPlaceMarketRecipe.tryPlaceRecipe(recipeHolder, stackedItemContents);
    }

    private RecipeBookMenu.PostPlaceAction tryPlaceRecipe(RecipeHolder<MarketRecipe> recipeHolder, StackedItemContents stackedItemContents) {
        if (stackedItemContents.canCraft(recipeHolder.value(), null)) {
            this.placeRecipe(recipeHolder, stackedItemContents);
            this.inventory.setChanged();
            return RecipeBookMenu.PostPlaceAction.NOTHING;
        }
        this.clearPayment();
        this.inventory.setChanged();
        return RecipeBookMenu.PostPlaceAction.PLACE_GHOST_RECIPE;
    }

    private void placeRecipe(RecipeHolder<MarketRecipe> recipeHolder, StackedItemContents stackedItemContents) {
        if (!this.menuAccess.recipeMatches(recipeHolder)) {
            this.clearPayment();
        }
        ArrayList itemsToUse = new ArrayList();
        if (stackedItemContents.canCraft(recipeHolder.value(), itemsToUse::add)) {
            Payment effectivePayment = MarketDefaultsRegistry.resolvePayment((MarketRecipe)recipeHolder.value());
            ItemStack paymentSlotItem = this.paymentSlot.getItem();
            int desiredCount = Math.min(this.paymentSlot.getMaxStackSize(), this.useMaxItems ? stackedItemContents.getBiggestCraftableStack(recipeHolder.value(), null) * effectivePayment.count() : paymentSlotItem.getCount() + effectivePayment.count());
            Holder itemToUse = (Holder)itemsToUse.getFirst();
            while (paymentSlotItem.getCount() < desiredCount) {
                int desiredAddition = desiredCount - paymentSlotItem.getCount();
                int foundSlot = this.inventory.findSlotMatchingCraftingIngredient(itemToUse, paymentSlotItem);
                if (foundSlot == -1) break;
                ItemStack slotItem = this.inventory.getItem(foundSlot);
                int toTake = Math.min(slotItem.getCount(), desiredAddition);
                if (paymentSlotItem.isEmpty()) {
                    this.paymentSlot.set(slotItem.split(toTake));
                    paymentSlotItem = this.paymentSlot.getItem();
                    continue;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)paymentSlotItem, (ItemStack)slotItem) || (toTake = Math.min(toTake, paymentSlotItem.getMaxStackSize() - paymentSlotItem.getCount())) <= 0) break;
                slotItem.shrink(toTake);
                paymentSlotItem.grow(toTake);
            }
        }
    }

    private boolean testClearPayment() {
        ItemStack restItem = this.paymentSlot.getItem().copy();
        if (restItem.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack slotItem = this.inventory.getItem(i);
            if (slotItem.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)restItem, (ItemStack)slotItem)) continue;
            int availableSpace = slotItem.getMaxStackSize() - slotItem.getCount();
            if (availableSpace > 0) {
                restItem.shrink(availableSpace);
            }
            if (!restItem.isEmpty()) continue;
            return true;
        }
        return restItem.isEmpty();
    }

    private void clearPayment() {
        ItemStack itemstack = this.paymentSlot.getItem().copy();
        this.inventory.placeItemBackInInventory(itemstack, false);
        this.paymentSlot.set(itemstack);
        this.menuAccess.clearCraftingContent();
    }
}

