/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.farmingforblockheads.api.Payment;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.blay09.mods.farmingforblockheads.recipe.MarketRecipeDisplay;
import net.blay09.mods.farmingforblockheads.recipe.ModRecipes;
import net.blay09.mods.farmingforblockheads.registry.MarketDefaultsRegistry;
import net.blay09.mods.farmingforblockheads.registry.PaymentImpl;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MarketRecipe
implements Recipe<RecipeInput> {
    private final String defaults;
    private final ResourceLocation category;
    private final ItemStack result;
    private final ItemStack icon;
    private final Payment payment;
    private final int sortIndex;

    public MarketRecipe(ItemStack result, String defaults, Optional<ResourceLocation> category, Optional<Payment> payment, int sortIndex, Optional<ItemStack> icon) {
        this.defaults = defaults;
        this.category = category.orElse(null);
        this.result = result;
        this.icon = icon.orElse(result);
        this.payment = payment.orElse(null);
        this.sortIndex = sortIndex;
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        ItemStack itemStack;
        Payment effectivePayment = MarketDefaultsRegistry.resolvePayment(this);
        Ingredient ingredient = effectivePayment.ingredient();
        return ingredient.test(itemStack = recipeInput.getItem(0)) && itemStack.getCount() >= effectivePayment.count();
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public ItemStack result() {
        return this.result;
    }

    public String getDefaults() {
        return this.defaults;
    }

    public boolean enabled() {
        return MarketDefaultsRegistry.isEnabled(this);
    }

    private SlotDisplay paymentSlotDisplay(Payment payment) {
        Ingredient ingredient = payment.ingredient();
        ArrayList slotDisplays = new ArrayList();
        ingredient.items().map(it -> new ItemStack((ItemLike)it.value(), payment.count())).map(SlotDisplay.ItemStackSlotDisplay::new).forEach(slotDisplays::add);
        return new SlotDisplay.Composite(slotDisplays);
    }

    public List<RecipeDisplay> display() {
        Payment effectivePayment = MarketDefaultsRegistry.resolvePayment(this);
        ResourceLocation effectiveCategory = MarketDefaultsRegistry.resolveCategory(this);
        return List.of(new MarketRecipeDisplay(this.paymentSlotDisplay(effectivePayment), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(this.result()), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(ModBlocks.market.asItem()), effectiveCategory, this.sortIndex, this.enabled(), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(this.icon)));
    }

    public RecipeSerializer<? extends Recipe<RecipeInput>> getSerializer() {
        return ModRecipes.marketRecipeSerializer;
    }

    public RecipeType<? extends Recipe<RecipeInput>> getType() {
        return ModRecipes.marketRecipeType;
    }

    public PlacementInfo placementInfo() {
        Payment effectivePayment = MarketDefaultsRegistry.resolvePayment(this);
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (int i = 0; i < effectivePayment.count(); ++i) {
            ingredients.add(effectivePayment.ingredient());
        }
        return PlacementInfo.create(ingredients);
    }

    public RecipeBookCategory recipeBookCategory() {
        return ModRecipes.marketRecipeBookCategory;
    }

    public Optional<Payment> getPayment() {
        return Optional.ofNullable(this.payment);
    }

    public Optional<ResourceLocation> getCategory() {
        return Optional.ofNullable(this.category);
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    static class Serializer
    implements RecipeSerializer<MarketRecipe> {
        private static final MapCodec<ItemStack> RESULT_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("item").forGetter(ItemStack::getItemHolder), (App)ExtraCodecs.POSITIVE_INT.fieldOf("count").orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(ItemStack::getComponentsPatch)).apply((Applicative)instance, ItemStack::new));
        private static final MapCodec<MarketRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RESULT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)ExtraCodecs.NON_EMPTY_STRING.fieldOf("defaults").forGetter(recipe -> recipe.defaults), (App)ResourceLocation.CODEC.optionalFieldOf("category").forGetter(MarketRecipe::getCategory), (App)PaymentImpl.CODEC.optionalFieldOf("payment").forGetter(MarketRecipe::getPayment), (App)Codec.INT.fieldOf("sortIndex").orElse((Object)0).forGetter(MarketRecipe::getSortIndex), (App)ItemStack.CODEC.optionalFieldOf("icon").forGetter(recipe -> Optional.ofNullable(recipe.icon))).apply((Applicative)instance, MarketRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, MarketRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        Serializer() {
        }

        public MapCodec<MarketRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MarketRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static MarketRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            ItemStack resultItem = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
            String defaults = buf.readUtf();
            ResourceLocation category = buf.readResourceLocation();
            Payment payment = PaymentImpl.fromNetwork(buf);
            int sortIndex = buf.readVarInt();
            ItemStack icon = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
            return new MarketRecipe(resultItem, defaults, Optional.of(category), Optional.of(payment), sortIndex, Optional.of(icon));
        }

        public static void toNetwork(RegistryFriendlyByteBuf buf, MarketRecipe recipe) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)recipe.result);
            buf.writeUtf(recipe.defaults);
            buf.writeResourceLocation(recipe.category);
            PaymentImpl.toNetwork(buf, recipe.payment);
            buf.writeVarInt(recipe.sortIndex);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)recipe.icon);
        }
    }
}

