/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.registry;

import java.io.BufferedReader;
import java.io.File;
import java.nio.file.Files;
import java.util.Map;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheads;
import net.blay09.mods.farmingforblockheads.registry.MarketDefaultsRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;

public class MarketDefaultsLoader
implements ResourceManagerReloadListener {
    private static final FileToIdConverter MARKET_DEFAULTS = new FileToIdConverter("farmingforblockheads", "defaults.json");
    private final HolderLookup.Provider registries;

    public MarketDefaultsLoader(HolderLookup.Provider registries) {
        this.registries = registries;
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        MarketDefaultsRegistry registry = MarketDefaultsRegistry.INSTANCE;
        registry.clear();
        for (Map.Entry entry : MARKET_DEFAULTS.listMatchingResources(resourceManager).entrySet()) {
            try {
                BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                try {
                    registry.loadAdditionally(this.registries, reader);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception e) {
                FarmingForBlockheads.logger.error("Error loading Farming for Blockheads market defaults file at {}", entry.getKey(), (Object)e);
            }
        }
        File configFile = new File(Balm.getConfig().getConfigDir(), "farmingforblockheads/defaults.json");
        if (configFile.exists()) {
            try (BufferedReader reader = Files.newBufferedReader(configFile.toPath());){
                registry.loadAdditionally(this.registries, reader);
            }
            catch (Exception e) {
                FarmingForBlockheads.logger.error("Error loading Farming for Blockheads market defaults file at {}", (Object)configFile, (Object)e);
            }
        }
    }
}

