/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.client.gui.screen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.blay09.mods.balm.mixin.ScreenAccessor;
import net.blay09.mods.farmingforblockheads.api.MarketCategory;
import net.blay09.mods.farmingforblockheads.client.gui.widget.MarketFilterButton;
import net.blay09.mods.farmingforblockheads.menu.MarketListingSlot;
import net.blay09.mods.farmingforblockheads.menu.MarketMenu;
import net.blay09.mods.farmingforblockheads.mixin.GhostSlotsAccessor;
import net.blay09.mods.farmingforblockheads.recipe.MarketRecipeDisplay;
import net.blay09.mods.farmingforblockheads.registry.SimpleHolder;
import net.blay09.mods.kuma.api.Kuma;
import net.minecraft.class_10295;
import net.minecraft.class_10352;
import net.minecraft.class_10363;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_465;
import net.minecraft.class_518;
import net.minecraft.class_638;
import net.minecraft.class_9934;

public class MarketScreen
extends class_465<MarketMenu>
implements class_518 {
    private static final int SCROLLBAR_COLOR = -5592406;
    private static final int SCROLLBAR_Y = 8;
    private static final int SCROLLBAR_WIDTH = 7;
    private static final int SCROLLBAR_HEIGHT = 77;
    private static final int VISIBLE_ROWS = 4;
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"farmingforblockheads", (String)"textures/gui/market.png");
    private final List<MarketFilterButton> filterButtons = new ArrayList<MarketFilterButton>();
    private float time;
    private final class_9934 ghostSlots = new class_9934(() -> class_3532.method_15375((float)(this.time / 30.0f)));
    private int scrollBarScaledHeight;
    private int scrollBarXPos;
    private int scrollBarYPos;
    private int currentOffset;
    private int mouseClickY = -1;
    private int indexWhenClicked;
    private int lastNumberOfMoves;
    private class_342 searchBar;

    public MarketScreen(MarketMenu container, class_1661 playerInventory, class_2561 displayName) {
        super((class_1703)container, playerInventory, displayName);
    }

    public void method_25426() {
        this.field_2779 = 174;
        super.method_25426();
        class_327 font = class_310.method_1551().field_1772;
        this.searchBar = new class_342(font, this.field_2776 + this.field_2792 - 78, this.field_2800 - 5, 70, 10, this.searchBar, (class_2561)class_2561.method_43473());
        this.method_48265((class_364)this.searchBar);
        this.method_37063((class_364)this.searchBar);
        this.updateCategoryFilters();
        this.recalculateScrollBar();
    }

    private void updateCategoryFilters() {
        for (MarketFilterButton filterButton : this.filterButtons) {
            ((ScreenAccessor)this).balm_getChildren().remove((Object)filterButton);
            ((ScreenAccessor)this).balm_getRenderables().remove((Object)filterButton);
            ((ScreenAccessor)this).balm_getNarratables().remove((Object)filterButton);
        }
        this.filterButtons.clear();
        int curX = 87;
        int curY = -80;
        List<SimpleHolder<MarketCategory>> categories = ((MarketMenu)this.field_2797).getCategories();
        for (SimpleHolder<MarketCategory> category : categories) {
            MarketFilterButton filterButton = new MarketFilterButton(this.field_22789 / 2 + curX, this.field_22790 / 2 + curY, (MarketMenu)this.field_2797, category, button -> {
                if (((MarketMenu)this.field_2797).getCurrentCategory().map(it -> it.equals(category)).orElse(false).booleanValue()) {
                    ((MarketMenu)this.field_2797).setCategory(null);
                } else {
                    ((MarketMenu)this.field_2797).setCategory(category);
                }
                ((MarketMenu)this.field_2797).updateListingSlots();
                this.setCurrentOffset(this.currentOffset);
            });
            this.method_37063((class_364)filterButton);
            this.filterButtons.add(filterButton);
            if ((curY += 20) <= 60) continue;
            curY = -80;
            curX += 20;
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (Math.abs(deltaY) > 0.0) {
            this.setCurrentOffset(deltaY > 0.0 ? this.currentOffset - 1 : this.currentOffset + 1);
            return true;
        }
        return false;
    }

    public boolean method_25406(class_11909 event) {
        if (event.method_74245() != -1 && this.mouseClickY != -1) {
            this.mouseClickY = -1;
            this.indexWhenClicked = 0;
            this.lastNumberOfMoves = 0;
        }
        return super.method_25406(event);
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (event.method_74245() == 1 && event.comp_4798() >= (double)this.searchBar.method_46426() && event.comp_4799() < (double)(this.searchBar.method_46426() + this.searchBar.method_25368()) && event.comp_4799() >= (double)this.searchBar.method_46427() && event.comp_4799() < (double)(this.searchBar.method_46427() + this.searchBar.method_25364())) {
            this.searchBar.method_1852("");
            ((MarketMenu)this.field_2797).setSearch(null);
            ((MarketMenu)this.field_2797).updateListingSlots();
            this.setCurrentOffset(this.currentOffset);
            return true;
        }
        if (event.comp_4798() >= (double)this.scrollBarXPos && event.comp_4798() <= (double)(this.scrollBarXPos + 7) && event.comp_4799() >= (double)this.scrollBarYPos && event.comp_4799() <= (double)(this.scrollBarYPos + this.scrollBarScaledHeight)) {
            this.mouseClickY = (int)event.comp_4799();
            this.indexWhenClicked = this.currentOffset;
            return true;
        }
        return super.method_25402(event, doubleClick);
    }

    public boolean method_25400(class_11905 event) {
        boolean result = super.method_25400(event);
        ((MarketMenu)this.field_2797).setSearch(this.searchBar.method_1882());
        ((MarketMenu)this.field_2797).updateListingSlots();
        this.setCurrentOffset(this.currentOffset);
        return result;
    }

    public boolean method_25404(class_11908 event) {
        if (this.searchBar.method_25404(event) || this.searchBar.method_25370()) {
            if (event.method_74231()) {
                this.field_22787.field_1724.method_7346();
            } else {
                ((MarketMenu)this.field_2797).setSearch(this.searchBar.method_1882());
                ((MarketMenu)this.field_2797).updateListingSlots();
                this.setCurrentOffset(this.currentOffset);
            }
            return true;
        }
        return super.method_25404(event);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (!Kuma.hasControlDown()) {
            this.time += partialTicks;
        }
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int numberOfFiltersMoved;
        float pixelsPerFilter;
        if (((MarketMenu)this.field_2797).isScrollOffsetDirty()) {
            this.updateCategoryFilters();
            this.recalculateScrollBar();
            ((MarketMenu)this.field_2797).setScrollOffsetDirty(false);
        }
        class_327 font = this.field_22787.field_1772;
        guiGraphics.method_25290(class_10799.field_56883, TEXTURE, this.field_2776, this.field_2800 - 10, 0.0f, 0.0f, this.field_2792, this.field_2779 + 10, 256, 256);
        if (this.mouseClickY != -1 && (pixelsPerFilter = (float)(77 - this.scrollBarScaledHeight) / (float)Math.max(1, (int)Math.ceil((float)((MarketMenu)this.field_2797).getFilteredListCount() / 3.0f) - 4)) != 0.0f && (numberOfFiltersMoved = (int)((float)(mouseY - this.mouseClickY) / pixelsPerFilter)) != this.lastNumberOfMoves) {
            this.setCurrentOffset(this.indexWhenClicked + numberOfFiltersMoved);
            this.lastNumberOfMoves = numberOfFiltersMoved;
        }
        guiGraphics.method_51433(font, class_1074.method_4662((String)"container.farmingforblockheads.market", (Object[])new Object[0]), this.field_2776 + 10, this.field_2800 + 10, 0xFFFFFF, true);
        guiGraphics.method_25294(this.scrollBarXPos, this.scrollBarYPos, this.scrollBarXPos + 7, this.scrollBarYPos + this.scrollBarScaledHeight, -5592406);
    }

    protected void method_2388(class_332 guiGraphics, int x, int y) {
    }

    protected void method_64508(class_332 guiGraphics) {
        super.method_64508(guiGraphics);
        this.ghostSlots.method_62033(guiGraphics, this.field_22787, false);
    }

    protected void method_2380(class_332 guiGraphics, int x, int y) {
        super.method_2380(guiGraphics, x, y);
        this.ghostSlots.method_62032(guiGraphics, this.field_22787, x, y, this.field_2787);
    }

    protected void method_2383(class_1735 slot, int pSlotId, int pMouseButton, class_1713 pType) {
        super.method_2383(slot, pSlotId, pMouseButton, pType);
        if (slot == ((MarketMenu)this.field_2797).getResultSlot() || slot == ((MarketMenu)this.field_2797).getPaymentSlot() || slot instanceof MarketListingSlot) {
            this.ghostSlots.method_62029();
        }
    }

    public Collection<MarketFilterButton> getFilterButtons() {
        return this.filterButtons;
    }

    private void recalculateScrollBar() {
        int scrollBarTotalHeight = 76;
        this.scrollBarScaledHeight = (int)((double)scrollBarTotalHeight * Math.min(1.0, 4.0 / Math.ceil((float)((MarketMenu)this.field_2797).getFilteredListCount() / 3.0f)));
        this.scrollBarXPos = this.field_2776 + this.field_2792 - 7 - 9;
        this.scrollBarYPos = this.field_2800 + 8 + (scrollBarTotalHeight - this.scrollBarScaledHeight) * this.currentOffset / Math.max(1, (int)Math.ceil((float)((MarketMenu)this.field_2797).getFilteredListCount() / 3.0f) - 4);
    }

    private void setCurrentOffset(int currentOffset) {
        this.currentOffset = Math.max(0, Math.min(currentOffset, (int)Math.ceil((float)((MarketMenu)this.field_2797).getFilteredListCount() / 3.0f) - 4));
        ((MarketMenu)this.field_2797).setScrollOffset(this.currentOffset);
        this.recalculateScrollBar();
    }

    public void method_16891() {
    }

    public void method_64862(class_10295 recipeDisplay) {
        this.ghostSlots.method_62029();
        class_638 level = class_310.method_1551().field_1687;
        class_10352 contextMap = class_10363.method_65008((class_1937)level);
        class_9934 class_99342 = this.ghostSlots;
        if (class_99342 instanceof GhostSlotsAccessor) {
            GhostSlotsAccessor accessor = (GhostSlotsAccessor)class_99342;
            accessor.callSetResult(((MarketMenu)this.field_2797).getResultSlot(), contextMap, recipeDisplay.comp_3258());
            if (recipeDisplay instanceof MarketRecipeDisplay) {
                MarketRecipeDisplay marketRecipeDisplay = (MarketRecipeDisplay)recipeDisplay;
                accessor.callSetSlot(((MarketMenu)this.field_2797).getPaymentSlot(), contextMap, marketRecipeDisplay.payment(), true);
            }
        }
    }
}

