/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.client.render;

import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.farmingforblockheads.client.render.MerchantRenderState;
import net.blay09.mods.farmingforblockheads.entity.MerchantEntity;
import net.minecraft.class_10042;
import net.minecraft.class_10080;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_620;
import net.minecraft.class_927;
import net.minecraft.class_976;

public class MerchantRenderer
extends class_927<MerchantEntity, class_10080, class_620> {
    private static final class_2960 MERCHANT_TEXTURE = class_2960.method_60655((String)"farmingforblockheads", (String)"textures/entity/merchant.png");
    private static final Map<class_2960, class_2960> verifiedTextures = new HashMap<class_2960, class_2960>();

    public MerchantRenderer(class_5617.class_5618 context) {
        super(context, (class_583)new class_620(context.method_32167(class_5602.field_27675)), 0.5f);
        this.method_4046((class_3887)new class_976((class_3883)this, context.method_32170(), context.method_73540()));
    }

    public class_2960 getTextureLocation(class_10080 state) {
        class_2960 textureLocation;
        if (state instanceof MerchantRenderState) {
            MerchantRenderState merchantRenderState = (MerchantRenderState)state;
            v0 = merchantRenderState.textureLocation;
        } else {
            v0 = textureLocation = null;
        }
        if (textureLocation == null) {
            return MERCHANT_TEXTURE;
        }
        return verifiedTextures.computeIfAbsent(textureLocation, it -> {
            if (class_310.method_1551().method_1478().method_14486(it).isPresent()) {
                return it;
            }
            return MERCHANT_TEXTURE;
        });
    }

    public void submit(class_10080 renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        int diggingAnimation;
        poseStack.method_22903();
        if (renderState instanceof MerchantRenderState) {
            MerchantRenderState merchantRenderState = (MerchantRenderState)renderState;
            v0 = merchantRenderState.diggingAnimation;
        } else {
            v0 = diggingAnimation = 0;
        }
        if (diggingAnimation > 0) {
            poseStack.method_22904(0.0, (double)(-diggingAnimation) * 0.05, 0.0);
        }
        super.method_4054((class_10042)renderState, poseStack, submitNodeCollector, cameraRenderState);
        poseStack.method_22909();
    }

    public void extractRenderState(MerchantEntity entity, class_10080 state, float delta) {
        super.method_62355((class_1309)entity, (class_10042)state, delta);
        if (state instanceof MerchantRenderState) {
            MerchantRenderState merchantRenderState = (MerchantRenderState)state;
            merchantRenderState.textureLocation = entity.getTextureLocation();
            merchantRenderState.diggingAnimation = entity.getDiggingAnimation();
        }
    }

    protected boolean shouldShowName(MerchantEntity entity, double distance) {
        return entity.getDiggingAnimation() <= 0 && super.method_4071((class_1308)entity, distance);
    }

    public MerchantRenderState createRenderState() {
        return new MerchantRenderState();
    }
}

