/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.menu;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.farmingforblockheads.api.MarketCategory;
import net.blay09.mods.farmingforblockheads.api.Payment;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.blay09.mods.farmingforblockheads.menu.MarketListingSlot;
import net.blay09.mods.farmingforblockheads.menu.MarketPaymentContainer;
import net.blay09.mods.farmingforblockheads.menu.MarketPaymentSlot;
import net.blay09.mods.farmingforblockheads.menu.MarketResultContainer;
import net.blay09.mods.farmingforblockheads.menu.MarketResultSlot;
import net.blay09.mods.farmingforblockheads.menu.ModMenus;
import net.blay09.mods.farmingforblockheads.menu.ServerPlaceMarketRecipe;
import net.blay09.mods.farmingforblockheads.network.MarketPlaceRecipeMessage;
import net.blay09.mods.farmingforblockheads.recipe.MarketRecipe;
import net.blay09.mods.farmingforblockheads.recipe.MarketRecipeDisplay;
import net.blay09.mods.farmingforblockheads.recipe.ModRecipes;
import net.blay09.mods.farmingforblockheads.registry.MarketDefaultsRegistry;
import net.blay09.mods.farmingforblockheads.registry.PaymentImpl;
import net.blay09.mods.farmingforblockheads.registry.SimpleHolder;
import net.minecraft.class_10295;
import net.minecraft.class_10297;
import net.minecraft.class_10298;
import net.minecraft.class_10352;
import net.minecraft.class_10363;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1729;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2955;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9875;
import org.jetbrains.annotations.Nullable;

public class MarketMenu
extends class_1703 {
    private static final int PAYMENT_SLOT = 0;
    private static final int RESULT_SLOT = 1;
    private static final int LISTING_SLOT_START = 2;
    private static final int LISTING_SLOT_END = 14;
    private static final int INV_SLOT_START = 14;
    private static final int INV_SLOT_END = 41;
    private static final int USE_ROW_SLOT_START = 41;
    private static final int USE_ROW_SLOT_END = 50;
    private final class_3914 access;
    private final class_1657 player;
    private boolean placingRecipe;
    private final MarketPaymentContainer paymentSlots = new MarketPaymentContainer(this, 1);
    private final MarketResultContainer resultSlots = new MarketResultContainer();
    private final List<MarketListingSlot> listingSlots = new ArrayList<MarketListingSlot>();
    private List<SimpleHolder<MarketCategory>> categories = List.of();
    private List<class_10297> recipes = List.of();
    private String currentSearch;
    private SimpleHolder<MarketCategory> currentCategory;
    private boolean scrollOffsetDirty;
    private int scrollOffset;
    private final List<class_10297> filteredRecipes = new ArrayList<class_10297>();
    private class_10297 selectedRecipeDisplayEntry;
    private class_8786<MarketRecipe> serverSelectedRecipe;

    public MarketMenu(int windowId, class_1661 playerInventory, class_3914 access) {
        super((class_3917)ModMenus.market.get(), windowId);
        this.access = access;
        this.player = playerInventory.field_7546;
        this.method_7621(new MarketPaymentSlot((class_1263)this.paymentSlots, 0, 23, 39));
        this.method_7621(new MarketResultSlot(this.player, this.paymentSlots, (class_1263)this.resultSlots, 0, 61, 39));
        DefaultContainer fakeInventory = new DefaultContainer(12);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 3; ++j) {
                MarketListingSlot slot = new MarketListingSlot((class_1263)fakeInventory, j + i * 3, 102 + j * 18, 11 + i * 18, this.player.method_73183());
                this.listingSlots.add(slot);
                this.method_7621(slot);
            }
        }
        this.method_61624((class_1263)playerInventory, 8, 92);
    }

    protected static void slotChangedMarket(class_1703 menu, class_3218 level, class_1657 player, MarketPaymentContainer container, class_1731 resultContainer, @Nullable class_8786<MarketRecipe> recipeHolder) {
        class_9695 recipeInput = container.asRecipeInput();
        class_3222 serverPlayer = (class_3222)player;
        class_1799 resultItem = class_1799.field_8037;
        Optional foundRecipe = level.method_8503().method_3772().method_59993(ModRecipes.marketRecipeType, recipeInput, (class_1937)level, recipeHolder);
        if (foundRecipe.isPresent()) {
            class_1799 assembledStack;
            class_8786 foundRecipeHolder = (class_8786)foundRecipe.get();
            MarketRecipe recipe = (MarketRecipe)foundRecipeHolder.comp_1933();
            if (resultContainer.method_7665(serverPlayer, foundRecipeHolder) && (assembledStack = recipe.method_8116(recipeInput, (class_7225.class_7874)level.method_30349())).method_45435(level.method_45162())) {
                resultItem = assembledStack;
            }
        }
        resultContainer.method_5447(0, resultItem);
        menu.method_34245(1, resultItem);
        serverPlayer.field_13987.method_14364((class_2596)new class_2653(menu.field_7763, menu.method_37422(), 1, resultItem));
    }

    public void method_7609(class_1263 pContainer) {
        if (!this.placingRecipe) {
            this.access.method_17393((level, pos) -> {
                if (level instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)level;
                    MarketMenu.slotChangedMarket(this, serverLevel, this.player, this.paymentSlots, this.resultSlots, this.serverSelectedRecipe);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public class_1729.class_9885 handlePlacement(boolean useMaxItems, boolean creative, class_8786<?> genericRecipeHolder, class_3218 level, class_1661 inventory) {
        class_1729.class_9885 postPlaceAction;
        class_8786<?> recipeHolder = genericRecipeHolder;
        this.beginPlacingRecipe();
        if (this.serverSelectedRecipe != recipeHolder) {
            this.method_7607(this.player, (class_1263)this.paymentSlots);
        }
        try {
            postPlaceAction = ServerPlaceMarketRecipe.placeRecipe(new class_2955.class_9840<MarketRecipe>(){

                public void method_61237(class_9875 stackedItemContents) {
                    MarketMenu.this.fillPaymentSlotsStackedContents(stackedItemContents);
                }

                public void method_61236() {
                    MarketMenu.this.resultSlots.method_5448();
                    MarketMenu.this.paymentSlots.method_5448();
                }

                public boolean method_61238(class_8786<MarketRecipe> recipe) {
                    return ((MarketRecipe)recipe.comp_1933()).method_8115(MarketMenu.this.paymentSlots.asRecipeInput(), MarketMenu.this.owner().method_73183());
                }
            }, this.getPaymentSlot(), inventory, recipeHolder, useMaxItems, creative);
        }
        finally {
            this.finishPlacingRecipe(level, recipeHolder);
        }
        return postPlaceAction;
    }

    private void fillPaymentSlotsStackedContents(class_9875 stackedItemContents) {
        this.paymentSlots.method_7683(stackedItemContents);
    }

    public void beginPlacingRecipe() {
        this.placingRecipe = true;
    }

    public void finishPlacingRecipe(class_3218 level, class_8786<MarketRecipe> recipeHolder) {
        this.placingRecipe = false;
        this.serverSelectedRecipe = recipeHolder;
        MarketMenu.slotChangedMarket(this, level, this.player, this.paymentSlots, this.resultSlots, recipeHolder);
    }

    public void method_7595(class_1657 pPlayer) {
        super.method_7595(pPlayer);
        this.method_7607(this.player, (class_1263)this.paymentSlots);
    }

    public boolean method_7597(class_1657 player) {
        return MarketMenu.method_17695((class_3914)this.access, (class_1657)player, (class_2248)ModBlocks.market);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            itemStack = slotStack.method_7972();
            if (index == 1) {
                if (!this.method_7616(slotStack, 14, 50, true)) {
                    return class_1799.field_8037;
                }
                slot.method_7670(slotStack, itemStack);
            } else if (index == 0 ? !this.method_7616(slotStack, 14, 50, true) : (this.isPayment(slotStack) ? !this.method_7616(slotStack, 0, 1, true) : (index >= 41 && index < 50 ? !this.method_7616(slotStack, 14, 41, true) : index >= 14 && index < 41 && !this.method_7616(slotStack, 41, 50, false)))) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (slotStack.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, slotStack);
        }
        return itemStack;
    }

    private boolean isPayment(class_1799 itemStack) {
        class_10295 class_102952;
        if (this.selectedRecipeDisplayEntry != null && (class_102952 = this.selectedRecipeDisplayEntry.comp_3263()) instanceof MarketRecipeDisplay) {
            MarketRecipeDisplay marketRecipeDisplay = (MarketRecipeDisplay)class_102952;
            class_10352 contextMap = class_10363.method_65008((class_1937)this.player.method_73183());
            List paymentStacks = marketRecipeDisplay.payment().method_64738(contextMap);
            for (class_1799 paymentStack : paymentStacks) {
                if (!class_1799.method_31577((class_1799)paymentStack, (class_1799)itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean method_7613(class_1799 itemStack, class_1735 slot) {
        return slot.field_7871 != this.resultSlots && super.method_7613(itemStack, slot);
    }

    public class_1735 getPaymentSlot() {
        return (class_1735)this.field_7761.get(0);
    }

    public class_1735 getResultSlot() {
        return (class_1735)this.field_7761.get(1);
    }

    protected class_1657 owner() {
        return this.player;
    }

    public void method_7593(int slotNumber, int dragType, class_1713 clickType, class_1657 player) {
        if (slotNumber >= 0 && slotNumber < this.field_7761.size()) {
            MarketListingSlot listingSlot;
            class_10297 recipe;
            class_1735 slot = (class_1735)this.field_7761.get(slotNumber);
            if (player.method_73183().method_8608() && clickType != class_1713.field_7793 && slot instanceof MarketListingSlot && (recipe = (listingSlot = (MarketListingSlot)slot).getRecipeDisplayEntry()) != null) {
                this.selectedRecipeDisplayEntry = recipe;
                Balm.getNetworking().sendToServer((class_8710)new MarketPlaceRecipeMessage(this.field_7763, recipe.comp_3262(), clickType == class_1713.field_7794));
            }
        }
        super.method_7593(slotNumber, dragType, clickType, player);
    }

    public void setSearch(@Nullable String term) {
        this.currentSearch = term;
        this.updateFilteredRecipes();
        this.setScrollOffset(0);
    }

    public void setCategory(@Nullable SimpleHolder<MarketCategory> category) {
        this.currentCategory = category;
        this.updateFilteredRecipes();
        this.setScrollOffset(0);
    }

    private void updateFilteredRecipes() {
        this.filteredRecipes.clear();
        for (class_10297 recipe : this.recipes) {
            if (!this.searchMatches(recipe) || !this.categoryMatches(recipe)) continue;
            this.filteredRecipes.add(recipe);
        }
        this.filteredRecipes.sort(this.sorting());
    }

    private boolean searchMatches(class_10297 recipeDisplayEntry) {
        if (this.currentSearch == null || this.currentSearch.trim().isEmpty()) {
            return true;
        }
        class_10352 contextMap = class_10363.method_65008((class_1937)this.player.method_73183());
        class_1799 resultItem = recipeDisplayEntry.comp_3263().comp_3258().method_64742(contextMap);
        String lowerCaseSearch = this.currentSearch.toLowerCase();
        if (resultItem.method_7954().getString().toLowerCase(Locale.ENGLISH).contains(lowerCaseSearch)) {
            return true;
        }
        List tooltips = resultItem.method_7950(class_1792.class_9635.field_51353, this.player, (class_1836)class_1836.class_1837.field_41070);
        for (class_2561 tooltip : tooltips) {
            if (!tooltip.getString().toLowerCase(Locale.ENGLISH).contains(lowerCaseSearch)) continue;
            return true;
        }
        return false;
    }

    private boolean categoryMatches(class_10297 recipeDisplayEntry) {
        if (this.currentCategory == null) {
            return true;
        }
        class_10295 display = recipeDisplayEntry.comp_3263();
        if (display instanceof MarketRecipeDisplay) {
            MarketRecipeDisplay marketRecipeDisplay = (MarketRecipeDisplay)display;
            class_2960 marketCategory = marketRecipeDisplay.category();
            return marketCategory.equals((Object)this.currentCategory.id());
        }
        return true;
    }

    public int getFilteredListCount() {
        return this.filteredRecipes.size();
    }

    public void setScrollOffset(int scrollOffset) {
        this.scrollOffset = scrollOffset;
        this.updateListingSlots();
    }

    public void updateListingSlots() {
        int i = this.scrollOffset * 3;
        for (MarketListingSlot slot : this.listingSlots) {
            if (i < this.filteredRecipes.size()) {
                slot.setRecipeDisplayEntry(this.filteredRecipes.get(i));
                ++i;
                continue;
            }
            slot.setRecipeDisplayEntry(null);
        }
    }

    public boolean isScrollOffsetDirty() {
        return this.scrollOffsetDirty;
    }

    public void setScrollOffsetDirty(boolean scrollOffsetDirty) {
        this.scrollOffsetDirty = scrollOffsetDirty;
    }

    public Optional<SimpleHolder<MarketCategory>> getCurrentCategory() {
        return Optional.ofNullable(this.currentCategory);
    }

    public List<SimpleHolder<MarketCategory>> getCategories() {
        return this.categories;
    }

    public void setRecipes(List<class_10297> recipes) {
        this.recipes = recipes;
        this.updateFilteredRecipes();
        this.setScrollOffset(0);
    }

    public void setCategories(List<SimpleHolder<MarketCategory>> categories) {
        this.categories = categories;
        this.setScrollOffsetDirty(true);
    }

    private Optional<MarketCategory> resolveMarketCategory(class_2960 identifier) {
        return this.categories.stream().filter(it -> it.id().equals((Object)identifier)).findFirst().map(SimpleHolder::value);
    }

    private Comparator<class_10297> sorting() {
        class_10352 contextMap = class_10363.method_65008((class_1937)this.player.method_73183());
        return Comparator.comparingInt(recipe -> {
            int n;
            class_10295 patt0$temp = recipe.comp_3263();
            if (patt0$temp instanceof MarketRecipeDisplay) {
                MarketRecipeDisplay marketRecipeDisplay = (MarketRecipeDisplay)patt0$temp;
                n = this.resolveMarketCategory(marketRecipeDisplay.category()).map(MarketCategory::sortIndex).orElse(0);
            } else {
                n = 0;
            }
            return n;
        }).thenComparing(recipe -> {
            Integer n;
            class_10295 patt0$temp = recipe.comp_3263();
            if (patt0$temp instanceof MarketRecipeDisplay) {
                MarketRecipeDisplay marketRecipeDisplay = (MarketRecipeDisplay)patt0$temp;
                n = marketRecipeDisplay.sortIndex();
            } else {
                n = 0;
            }
            return n;
        }).thenComparing(recipe -> {
            class_1799 class_17992;
            class_10295 patt0$temp = recipe.comp_3263();
            if (patt0$temp instanceof MarketRecipeDisplay) {
                MarketRecipeDisplay marketRecipeDisplay = (MarketRecipeDisplay)patt0$temp;
                class_17992 = marketRecipeDisplay.icon().method_64742(contextMap);
            } else {
                class_17992 = recipe.comp_3263().comp_3258().method_64742(contextMap);
            }
            return class_17992.method_7954().getString();
        });
    }

    public boolean containsRecipeDisplayId(class_10298 recipeDisplayId) {
        return this.recipes.stream().anyMatch(it -> it.comp_3262().equals((Object)recipeDisplayId));
    }

    public Optional<Payment> getExpectedPayment() {
        class_10295 class_102952;
        if (this.serverSelectedRecipe != null) {
            return Optional.of(MarketDefaultsRegistry.resolvePayment((MarketRecipe)this.serverSelectedRecipe.comp_1933()));
        }
        if (this.selectedRecipeDisplayEntry != null && (class_102952 = this.selectedRecipeDisplayEntry.comp_3263()) instanceof MarketRecipeDisplay) {
            MarketRecipeDisplay marketRecipeDisplay = (MarketRecipeDisplay)class_102952;
            class_10352 contextMap = class_10363.method_65008((class_1937)this.player.method_73183());
            List paymentItems = marketRecipeDisplay.payment().method_64738(contextMap);
            class_1856 ingredient = class_1856.method_26964(paymentItems.stream().map(class_1799::method_7909));
            return Optional.of(new PaymentImpl(ingredient, 0, Optional.empty()));
        }
        return Optional.empty();
    }
}

