/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.farmingforblockheads.api.Payment;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.blay09.mods.farmingforblockheads.recipe.MarketRecipeDisplay;
import net.blay09.mods.farmingforblockheads.recipe.ModRecipes;
import net.blay09.mods.farmingforblockheads.registry.MarketDefaultsRegistry;
import net.blay09.mods.farmingforblockheads.registry.PaymentImpl;
import net.minecraft.class_10295;
import net.minecraft.class_10302;
import net.minecraft.class_10355;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9326;
import net.minecraft.class_9695;
import net.minecraft.class_9887;

public class MarketRecipe
implements class_1860<class_9695> {
    private final String defaults;
    private final class_2960 category;
    private final class_1799 result;
    private final class_1799 icon;
    private final Payment payment;
    private final int sortIndex;

    public MarketRecipe(class_1799 result, String defaults, Optional<class_2960> category, Optional<Payment> payment, int sortIndex, Optional<class_1799> icon) {
        this.defaults = defaults;
        this.category = category.orElse(null);
        this.result = result;
        this.icon = icon.orElse(result);
        this.payment = payment.orElse(null);
        this.sortIndex = sortIndex;
    }

    public boolean method_8115(class_9695 recipeInput, class_1937 level) {
        class_1799 itemStack;
        Payment effectivePayment = MarketDefaultsRegistry.resolvePayment(this);
        class_1856 ingredient = effectivePayment.ingredient();
        return ingredient.method_8093(itemStack = recipeInput.method_59984(0)) && itemStack.method_7947() >= effectivePayment.count();
    }

    public class_1799 method_8116(class_9695 recipeInput, class_7225.class_7874 provider) {
        return this.result.method_7972();
    }

    public class_1799 result() {
        return this.result;
    }

    public String getDefaults() {
        return this.defaults;
    }

    public boolean enabled() {
        return MarketDefaultsRegistry.isEnabled(this);
    }

    private class_10302 paymentSlotDisplay(Payment payment) {
        class_1856 ingredient = payment.ingredient();
        ArrayList slotDisplays = new ArrayList();
        ingredient.method_8105().map(it -> new class_1799((class_1935)it.comp_349(), payment.count())).map(class_10302.class_10307::new).forEach(slotDisplays::add);
        return new class_10302.class_10304(slotDisplays);
    }

    public List<class_10295> method_64664() {
        Payment effectivePayment = MarketDefaultsRegistry.resolvePayment(this);
        class_2960 effectiveCategory = MarketDefaultsRegistry.resolveCategory(this);
        return List.of(new MarketRecipeDisplay(this.paymentSlotDisplay(effectivePayment), (class_10302)new class_10302.class_10307(this.result()), (class_10302)new class_10302.class_10306(ModBlocks.market.method_8389()), effectiveCategory, this.sortIndex, this.enabled(), (class_10302)new class_10302.class_10307(this.icon)));
    }

    public class_1865<? extends class_1860<class_9695>> method_8119() {
        return ModRecipes.marketRecipeSerializer;
    }

    public class_3956<? extends class_1860<class_9695>> method_17716() {
        return ModRecipes.marketRecipeType;
    }

    public class_9887 method_61671() {
        Payment effectivePayment = MarketDefaultsRegistry.resolvePayment(this);
        ArrayList<class_1856> ingredients = new ArrayList<class_1856>();
        for (int i = 0; i < effectivePayment.count(); ++i) {
            ingredients.add(effectivePayment.ingredient());
        }
        return class_9887.method_61686(ingredients);
    }

    public class_10355 method_64668() {
        return ModRecipes.marketRecipeBookCategory;
    }

    public Optional<Payment> getPayment() {
        return Optional.ofNullable(this.payment);
    }

    public Optional<class_2960> getCategory() {
        return Optional.ofNullable(this.category);
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    static class Serializer
    implements class_1865<MarketRecipe> {
        private static final MapCodec<class_1799> RESULT_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41178.method_40294().fieldOf("item").forGetter(class_1799::method_41409), (App)class_5699.field_33442.fieldOf("count").orElse((Object)1).forGetter(class_1799::method_7947), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(class_1799::method_57380)).apply((Applicative)instance, class_1799::new));
        private static final MapCodec<MarketRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RESULT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)class_5699.field_41759.fieldOf("defaults").forGetter(recipe -> recipe.defaults), (App)class_2960.field_25139.optionalFieldOf("category").forGetter(MarketRecipe::getCategory), (App)PaymentImpl.CODEC.optionalFieldOf("payment").forGetter(MarketRecipe::getPayment), (App)Codec.INT.fieldOf("sortIndex").orElse((Object)0).forGetter(MarketRecipe::getSortIndex), (App)class_1799.field_24671.optionalFieldOf("icon").forGetter(recipe -> Optional.ofNullable(recipe.icon))).apply((Applicative)instance, MarketRecipe::new));
        public static final class_9139<class_9129, MarketRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

        Serializer() {
        }

        public MapCodec<MarketRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, MarketRecipe> method_56104() {
            return STREAM_CODEC;
        }

        public static MarketRecipe fromNetwork(class_9129 buf) {
            class_1799 resultItem = (class_1799)class_1799.field_49268.decode((Object)buf);
            String defaults = buf.method_19772();
            class_2960 category = buf.method_10810();
            Payment payment = PaymentImpl.fromNetwork(buf);
            int sortIndex = buf.method_10816();
            class_1799 icon = (class_1799)class_1799.field_49268.decode((Object)buf);
            return new MarketRecipe(resultItem, defaults, Optional.of(category), Optional.of(payment), sortIndex, Optional.of(icon));
        }

        public static void toNetwork(class_9129 buf, MarketRecipe recipe) {
            class_1799.field_49268.encode((Object)buf, (Object)recipe.result);
            buf.method_10814(recipe.defaults);
            buf.method_10812(recipe.category);
            PaymentImpl.toNetwork(buf, recipe.payment);
            buf.method_10804(recipe.sortIndex);
            class_1799.field_49268.encode((Object)buf, (Object)recipe.icon);
        }
    }
}

