/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.registry;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheadsConfig;
import net.blay09.mods.farmingforblockheads.api.MarketDefault;
import net.blay09.mods.farmingforblockheads.api.Payment;
import net.blay09.mods.farmingforblockheads.recipe.MarketRecipe;
import net.blay09.mods.farmingforblockheads.registry.CompositeMarketDefault;
import net.blay09.mods.farmingforblockheads.registry.MarketDefaultImpl;
import net.blay09.mods.farmingforblockheads.registry.PaymentImpl;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_6903;
import net.minecraft.class_7225;

public class MarketDefaultsRegistry {
    private static final Codec<MarketDefault> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("category").forGetter(MarketDefault::category), (App)PaymentImpl.CODEC.optionalFieldOf("payment").forGetter(MarketDefault::payment)).apply((Applicative)instance, MarketDefaultImpl::new));
    public static final MarketDefaultsRegistry INSTANCE = new MarketDefaultsRegistry();
    private static final MarketDefault EMPTY_DEFAULT = new MarketDefaultImpl(Optional.empty(), Optional.empty());
    private final Map<String, MarketDefault> defaultsByGroup = new HashMap<String, MarketDefault>();

    public void register(String group, MarketDefault preset) {
        this.defaultsByGroup.put(group, preset);
    }

    public void clear() {
        this.defaultsByGroup.clear();
    }

    public void loadAdditionally(class_7225.class_7874 registries, BufferedReader reader) {
        Gson gson = new Gson();
        JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registries);
        for (Map.Entry entry : json.entrySet()) {
            MarketDefault defaults = (MarketDefault)CODEC.parse((DynamicOps)ops, (Object)((JsonElement)entry.getValue())).getOrThrow();
            this.register((String)entry.getKey(), defaults);
        }
    }

    public static MarketDefault resolveExactDefault(String defaults) {
        return MarketDefaultsRegistry.INSTANCE.defaultsByGroup.getOrDefault(defaults, EMPTY_DEFAULT);
    }

    public static List<String> flattenDefaults(String defaults) {
        ArrayList<String> result = new ArrayList<String>();
        String[] parts = defaults.split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j <= i; ++j) {
                if (j > 0) {
                    sb.append('.');
                }
                sb.append(parts[j]);
            }
            String key = sb.toString();
            result.add(key);
        }
        return result;
    }

    public static MarketDefault resolveDefaults(MarketRecipe recipe) {
        List<MarketDefault> result = MarketDefaultsRegistry.flattenDefaults(recipe.getDefaults()).stream().map(MarketDefaultsRegistry::resolveExactDefault).toList();
        return new CompositeMarketDefault(result);
    }

    public static class_2960 resolveCategory(MarketRecipe recipe) {
        MarketDefault defaults = MarketDefaultsRegistry.resolveDefaults(recipe);
        return recipe.getCategory().orElse(defaults.category().orElseGet(MarketDefaultsRegistry::defaultCategory));
    }

    public static Payment resolvePayment(MarketRecipe recipe) {
        MarketDefault defaults = MarketDefaultsRegistry.resolveDefaults(recipe);
        return recipe.getPayment().orElse(defaults.payment().orElseGet(MarketDefaultsRegistry::defaultPayment));
    }

    public static boolean isEnabled(MarketRecipe recipe) {
        String group;
        List<String> recipeGroups = MarketDefaultsRegistry.flattenDefaults(recipe.getDefaults());
        Set<String> includedGroups = FarmingForBlockheadsConfig.getActive().includedGroups;
        Set<String> excludedGroups = FarmingForBlockheadsConfig.getActive().excludedGroups;
        boolean useDefaultIncludedGroups = includedGroups.contains("default") && !excludedGroups.contains("default");
        boolean enabled = false;
        Iterator iterator = recipeGroups.reversed().iterator();
        while (iterator.hasNext() && !excludedGroups.contains(group = (String)iterator.next())) {
            if (includedGroups.contains(group)) {
                enabled = true;
                break;
            }
            if (!useDefaultIncludedGroups || !FarmingForBlockheadsConfig.DEFAULT_INCLUDED_GROUPS.contains(group)) continue;
            enabled = true;
            break;
        }
        return enabled;
    }

    private static class_2960 defaultCategory() {
        return class_2960.method_60655((String)"farmingforblockheads", (String)"other");
    }

    private static Payment defaultPayment() {
        return new PaymentImpl(class_1856.method_8101((class_1935)class_1802.field_8687), 1, Optional.empty());
    }
}

