/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.menu;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.farmingforblockheads.api.MarketCategory;
import net.blay09.mods.farmingforblockheads.api.Payment;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.blay09.mods.farmingforblockheads.menu.MarketBasketSlot;
import net.blay09.mods.farmingforblockheads.menu.MarketListingSlot;
import net.blay09.mods.farmingforblockheads.menu.MarketPaymentSlot;
import net.blay09.mods.farmingforblockheads.menu.ModMenus;
import net.blay09.mods.farmingforblockheads.network.MarketPutInBasketMessage;
import net.blay09.mods.farmingforblockheads.recipe.MarketRecipe;
import net.blay09.mods.farmingforblockheads.recipe.ModRecipes;
import net.blay09.mods.farmingforblockheads.registry.MarketCategoryRegistry;
import net.blay09.mods.farmingforblockheads.registry.MarketPresetRegistry;
import net.blay09.mods.farmingforblockheads.registry.PaymentImpl;
import net.blay09.mods.farmingforblockheads.registry.SimpleHolder;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1715;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class MarketMenu
extends class_1703 {
    public static final class_9139<class_9129, Data> STREAM_CODEC = class_9139.method_56437((buf, data) -> {
        buf.method_10807(data.pos());
        buf.method_53002(data.presetFilters().size());
        for (class_2960 location : data.presetFilters()) {
            buf.method_10812(location);
        }
        buf.method_53002(data.categoryFilters().size());
        for (class_2960 location : data.categoryFilters()) {
            buf.method_10812(location);
        }
    }, buf -> {
        class_2338 pos = buf.method_10811();
        int presetFilterSize = buf.readInt();
        HashSet<class_2960> presetFilters = new HashSet<class_2960>();
        for (int i = 0; i < presetFilterSize; ++i) {
            presetFilters.add(buf.method_10810());
        }
        int categoryFilterSize = buf.readInt();
        HashSet<class_2960> categoryFilters = new HashSet<class_2960>();
        for (int i = 0; i < categoryFilterSize; ++i) {
            categoryFilters.add(buf.method_10810());
        }
        return new Data(pos, presetFilters, categoryFilters);
    });
    private final class_1657 player;
    private final class_2338 pos;
    private final DefaultContainer marketInputBuffer = new DefaultContainer(1);
    private final DefaultContainer marketOutputBuffer = new DefaultContainer(1);
    private final List<MarketListingSlot> marketSlots = new ArrayList<MarketListingSlot>();
    private final MarketPaymentSlot paymentSlot;
    private final List<SimpleHolder<MarketCategory>> categories;
    private final List<class_8786<MarketRecipe>> recipes;
    private String currentSearch;
    private SimpleHolder<MarketCategory> currentCategory;
    private final Comparator<class_8786<MarketRecipe>> currentSorting = Comparator.comparingInt(recipe -> MarketCategoryRegistry.INSTANCE.get(((MarketRecipe)recipe.comp_1933()).getCategory()).map(MarketCategory::sortIndex).orElse(0)).thenComparing(recipe -> ((MarketRecipe)recipe.comp_1933()).getIcon().method_7954().getString());
    private boolean scrollOffsetDirty;
    private int scrollOffset;
    private final List<class_8786<MarketRecipe>> filteredRecipes = new ArrayList<class_8786<MarketRecipe>>();
    private class_8786<MarketRecipe> selectedRecipe;

    public MarketMenu(int windowId, class_1661 playerInventory, class_2338 pos, Set<class_2960> alwaysIncludedPresets, Set<class_2960> includeOnlyCategories) {
        super((class_3917)ModMenus.market.get(), windowId);
        int j;
        int i;
        this.player = playerInventory.field_7546;
        this.pos = pos;
        this.recipes = this.player.method_37908().method_8433().method_30027(ModRecipes.marketRecipeType).stream().filter(recipe -> MarketPresetRegistry.isRecipeEnabled((MarketRecipe)recipe.comp_1933(), alwaysIncludedPresets)).toList();
        this.categories = MarketCategoryRegistry.INSTANCE.getAll().entrySet().stream().filter(entry -> includeOnlyCategories.isEmpty() || includeOnlyCategories.contains(entry.getKey())).filter(entry -> this.recipes.stream().anyMatch(it -> ((MarketRecipe)it.comp_1933()).getCategory().equals(entry.getKey()))).sorted(Comparator.comparingInt(entry -> ((MarketCategory)entry.getValue()).sortIndex())).map(it -> new SimpleHolder<MarketCategory>((class_2960)it.getKey(), (MarketCategory)it.getValue())).toList();
        this.paymentSlot = new MarketPaymentSlot((class_1263)this.marketInputBuffer, 0, 23, 39);
        this.method_7621(this.paymentSlot);
        this.method_7621(new MarketBasketSlot(this, (class_1263)this.marketOutputBuffer, 0, 61, 39));
        DefaultContainer fakeInventory = new DefaultContainer(12);
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 3; ++j) {
                MarketListingSlot slot = new MarketListingSlot((class_1263)fakeInventory, j + i * 3, 102 + j * 18, 11 + i * 18);
                this.marketSlots.add(slot);
                this.method_7621(slot);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)playerInventory, j + i * 9 + 9, 8 + j * 18, 92 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, i, 8 + i * 18, 150));
        }
        this.updateFilteredRecipes();
        this.setScrollOffset(0);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            itemStack = slotStack.method_7972();
            if (index == 1) {
                if (!this.isReadyToBuy()) {
                    return class_1799.field_8037;
                }
                if (!this.method_7616(slotStack, 14, 50, true)) {
                    return class_1799.field_8037;
                }
                slot.method_7670(slotStack, itemStack);
            } else if (index == 0 ? !this.method_7616(slotStack, 14, 50, true) : (this.getExpectedPayment(this.selectedRecipe).ingredient().method_8093(slotStack) ? !this.method_7616(slotStack, 0, 1, true) : (index >= 41 && index < 50 ? !this.method_7616(slotStack, 14, 41, true) : index >= 14 && index < 41 && !this.method_7616(slotStack, 41, 50, false)))) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (slotStack.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, slotStack);
        }
        return itemStack;
    }

    public void method_7595(class_1657 player) {
        class_1799 itemStack;
        super.method_7595(player);
        if (!(player.method_37908().field_9236 || (itemStack = this.marketInputBuffer.method_5441(0)).method_7960() || player.method_7270(itemStack))) {
            player.method_7328(itemStack, false);
        }
    }

    public boolean method_7597(class_1657 player) {
        return player.method_37908().method_8320(this.pos).method_26204() == ModBlocks.market && player.method_5649((double)this.pos.method_10263() + 0.5, (double)this.pos.method_10264() + 0.5, (double)this.pos.method_10260() + 0.5) <= 64.0;
    }

    public void method_7609(class_1263 container) {
        if (this.selectedRecipe != null) {
            this.marketOutputBuffer.method_5447(0, ((MarketRecipe)this.selectedRecipe.comp_1933()).method_8116((class_9695)new class_1715((class_1703)this, 0, 0).method_59961(), (class_7225.class_7874)class_5455.field_40585));
        } else {
            this.marketOutputBuffer.method_5447(0, class_1799.field_8037);
        }
    }

    public boolean method_7613(class_1799 itemStack, class_1735 slot) {
        return slot.field_7871 != this.marketOutputBuffer && super.method_7613(itemStack, slot);
    }

    private Payment getExpectedPayment(@Nullable class_8786<MarketRecipe> recipe) {
        if (recipe == null) {
            return new PaymentImpl(class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8687}), 1, Optional.empty());
        }
        return ((MarketRecipe)recipe.comp_1933()).getPaymentOrDefault();
    }

    public void selectMarketEntry(class_2960 recipeId, boolean stack) {
        this.selectedRecipe = this.recipes.stream().filter(it -> it.comp_1932().equals((Object)recipeId)).findFirst().orElse(null);
        if (this.selectedRecipe != null) {
            Payment payment = ((MarketRecipe)this.selectedRecipe.comp_1933()).getPaymentOrDefault();
            class_1799 currentInput = this.marketInputBuffer.method_5438(0);
            if (!payment.ingredient().method_8093(currentInput)) {
                this.method_7601(this.player, 0);
                this.quickMoveCost(payment, stack ? 64 : 1);
            } else if (stack && currentInput.method_7947() < 64) {
                this.quickMoveCost(payment, 64);
            } else if (!stack && currentInput.method_7947() > 1) {
                this.method_7601(this.player, 0);
                this.quickMoveCost(payment, 1);
            }
        }
        this.method_7609((class_1263)this.marketInputBuffer);
    }

    private void quickMoveCost(Payment payment, int desiredCount) {
        this.paymentSlot.setMaxStackSizeOverride(desiredCount);
        for (int i = 14; i < this.field_7761.size(); ++i) {
            class_1799 slotStack = ((class_1735)this.field_7761.get(i)).method_7677();
            if (payment.ingredient().method_8093(slotStack)) {
                this.method_7601(this.player, i);
            }
            if (this.paymentSlot.method_7677().method_7947() >= desiredCount) break;
        }
        this.paymentSlot.resetMaxStackSizeOverride();
    }

    @Nullable
    public class_8786<MarketRecipe> getSelectedRecipe() {
        return this.selectedRecipe;
    }

    public boolean isReadyToBuy() {
        if (this.selectedRecipe == null) {
            return false;
        }
        Payment expectedPayment = this.getExpectedPayment(this.selectedRecipe);
        class_1799 currentInput = this.marketInputBuffer.method_5438(0);
        return !currentInput.method_7960() && expectedPayment.ingredient().method_8093(currentInput) && currentInput.method_7947() >= expectedPayment.count();
    }

    public void onItemBought() {
        if (this.selectedRecipe != null) {
            this.marketInputBuffer.method_5434(0, ((MarketRecipe)this.selectedRecipe.comp_1933()).getPaymentOrDefault().count());
            this.method_7609((class_1263)this.marketInputBuffer);
        }
    }

    public void method_7593(int slotNumber, int dragType, class_1713 clickType, class_1657 player) {
        if (slotNumber >= 0 && slotNumber < this.field_7761.size()) {
            MarketListingSlot marketSlot;
            class_8786<MarketRecipe> recipe;
            class_1735 slot = (class_1735)this.field_7761.get(slotNumber);
            if (player.method_37908().field_9236 && slot instanceof MarketListingSlot && (recipe = (marketSlot = (MarketListingSlot)slot).getRecipe()) != null) {
                this.selectedRecipe = recipe;
                Balm.getNetworking().sendToServer((class_8710)new MarketPutInBasketMessage(recipe.comp_1932(), clickType == class_1713.field_7794));
            }
        }
        super.method_7593(slotNumber, dragType, clickType, player);
    }

    public void setSearch(@Nullable String term) {
        this.currentSearch = term;
        this.updateFilteredRecipes();
        this.setScrollOffset(0);
    }

    public void setCategory(@Nullable SimpleHolder<MarketCategory> category) {
        this.currentCategory = category;
        this.updateFilteredRecipes();
        this.setScrollOffset(0);
    }

    private void updateFilteredRecipes() {
        this.filteredRecipes.clear();
        for (class_8786<MarketRecipe> recipe : this.recipes) {
            if (!this.searchMatches(recipe) || !this.categoryMatches(recipe)) continue;
            this.filteredRecipes.add(recipe);
        }
        this.filteredRecipes.sort(this.currentSorting);
    }

    private boolean searchMatches(class_8786<MarketRecipe> recipeHolder) {
        if (this.currentSearch == null || this.currentSearch.trim().isEmpty()) {
            return true;
        }
        MarketRecipe recipe = (MarketRecipe)recipeHolder.comp_1933();
        class_1799 itemStack = recipe.getIcon();
        String lowerCaseSearch = this.currentSearch.toLowerCase();
        if (itemStack.method_7954().getString().toLowerCase(Locale.ENGLISH).contains(lowerCaseSearch)) {
            return true;
        }
        List tooltips = itemStack.method_7950(class_1792.class_9635.field_51353, this.player, (class_1836)class_1836.class_1837.field_41070);
        for (class_2561 tooltip : tooltips) {
            if (!tooltip.getString().toLowerCase(Locale.ENGLISH).contains(lowerCaseSearch)) continue;
            return true;
        }
        return false;
    }

    private boolean categoryMatches(class_8786<MarketRecipe> recipeHolder) {
        if (this.currentCategory == null) {
            return true;
        }
        MarketRecipe recipe = (MarketRecipe)recipeHolder.comp_1933();
        return recipe.getCategory().equals((Object)this.currentCategory.id());
    }

    public int getFilteredListCount() {
        return this.filteredRecipes.size();
    }

    public void setScrollOffset(int scrollOffset) {
        this.scrollOffset = scrollOffset;
        this.updateListingSlots();
    }

    public void updateListingSlots() {
        int i = this.scrollOffset * 3;
        for (MarketListingSlot slot : this.marketSlots) {
            if (i < this.filteredRecipes.size()) {
                slot.setRecipe(this.filteredRecipes.get(i));
                ++i;
                continue;
            }
            slot.setRecipe(null);
        }
    }

    public boolean isScrollOffsetDirty() {
        return this.scrollOffsetDirty;
    }

    public void setScrollOffsetDirty(boolean scrollOffsetDirty) {
        this.scrollOffsetDirty = scrollOffsetDirty;
    }

    public Optional<SimpleHolder<MarketCategory>> getCurrentCategory() {
        return Optional.ofNullable(this.currentCategory);
    }

    public List<SimpleHolder<MarketCategory>> getCategories() {
        return this.categories;
    }

    public record Data(class_2338 pos, Set<class_2960> presetFilters, Set<class_2960> categoryFilters) {
    }
}

