/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.registry;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheads;
import net.blay09.mods.farmingforblockheads.registry.MarketPresetRegistry;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_7654;

public class MarketPresetLoader
implements class_4013 {
    private static final class_7654 MARKET_CATEGORIES = class_7654.method_45114((String)"market_presets");

    public void method_14491(class_3300 resourceManager) {
        MarketPresetRegistry registry = MarketPresetRegistry.INSTANCE;
        registry.clear();
        for (Map.Entry entry : MARKET_CATEGORIES.method_45113(resourceManager).entrySet()) {
            try {
                BufferedReader reader = ((class_3298)entry.getValue()).method_43039();
                try {
                    class_2960 id = MARKET_CATEGORIES.method_45115((class_2960)entry.getKey());
                    registry.loadAdditionally(id, reader);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception e) {
                FarmingForBlockheads.logger.error("Error loading Farming for Blockheads market preset file at {}", entry.getKey(), (Object)e);
            }
        }
        File configDir = new File(Balm.getConfig().getConfigDir(), "market_presets");
        if (configDir.exists() || configDir.mkdirs()) {
            try (Stream<Path> files = Files.walk(configDir.toPath(), new FileVisitOption[0]);){
                files.filter(it -> it.getFileName().endsWith(".json")).forEach(it -> {
                    class_2960 id = class_2960.method_60655((String)"farmingforblockheads", (String)it.getFileName().toString().replace(".json", ""));
                    try (BufferedReader reader = Files.newBufferedReader(it);){
                        registry.loadAdditionally(id, reader);
                    }
                    catch (Exception e) {
                        FarmingForBlockheads.logger.error("Error loading Farming for Blockheads market preset file at {}", it, (Object)e);
                    }
                });
            }
            catch (IOException e) {
                FarmingForBlockheads.logger.error("Error loading Farming for Blockheads market preset files from {}", (Object)configDir, (Object)e);
            }
        }
    }
}

