/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.registry;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheadsConfig;
import net.blay09.mods.farmingforblockheads.api.MarketPreset;
import net.blay09.mods.farmingforblockheads.recipe.MarketRecipe;
import net.blay09.mods.farmingforblockheads.registry.MarketPresetImpl;
import net.blay09.mods.farmingforblockheads.registry.PaymentImpl;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7225;

public class MarketPresetRegistry {
    private static final Codec<MarketPreset> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PaymentImpl.CODEC.fieldOf("payment").forGetter(MarketPreset::payment), (App)Codec.BOOL.fieldOf("enabled").orElse((Object)true).forGetter(MarketPreset::enabledByDefault)).apply((Applicative)instance, MarketPresetImpl::new));
    public static final MarketPresetRegistry INSTANCE = new MarketPresetRegistry();
    private final Map<class_2960, MarketPreset> presets = new HashMap<class_2960, MarketPreset>();

    public void register(class_2960 id, MarketPreset preset) {
        this.presets.put(id, preset);
    }

    public Set<Map.Entry<class_2960, MarketPreset>> getEntries() {
        return MarketPresetRegistry.INSTANCE.presets.entrySet();
    }

    public Collection<MarketPreset> getAll() {
        return MarketPresetRegistry.INSTANCE.presets.values();
    }

    public Optional<MarketPreset> get(class_2960 id) {
        return Optional.ofNullable(MarketPresetRegistry.INSTANCE.presets.get(id));
    }

    public void clear() {
        this.presets.clear();
    }

    public void loadAdditionally(class_2960 id, BufferedReader reader) {
        Gson gson = new Gson();
        JsonElement json = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
        MarketPreset category = (MarketPreset)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow();
        this.register(id, category);
    }

    public static boolean isRecipeEnabled(MarketRecipe recipe) {
        return MarketPresetRegistry.isRecipeEnabled(recipe, Collections.emptySet());
    }

    public static boolean isRecipeEnabled(MarketRecipe recipe, Set<class_2960> serverEnabledPresets) {
        Set<class_2960> disabledDefaultPresets = FarmingForBlockheadsConfig.getActive().disabledDefaultPresets;
        if (disabledDefaultPresets.contains(recipe.getPreset())) {
            return false;
        }
        boolean enabledByServer = serverEnabledPresets.contains(recipe.getPreset());
        Boolean enabledByDefault = INSTANCE.get(recipe.getPreset()).map(MarketPreset::enabledByDefault).orElse(false);
        Set<class_2960> enabledOptionalPresets = FarmingForBlockheadsConfig.getActive().enabledOptionalPresets;
        if (!(enabledByServer || enabledByDefault.booleanValue() || enabledOptionalPresets.contains(recipe.getPreset()))) {
            return false;
        }
        return !recipe.method_8110((class_7225.class_7874)class_5455.field_40585).method_7960();
    }
}

