/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.block.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.farmingforblockheads.api.FarmingForBlockheadsAPI;
import net.blay09.mods.farmingforblockheads.api.MarketCategory;
import net.blay09.mods.farmingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.farmingforblockheads.menu.MarketMenu;
import net.blay09.mods.farmingforblockheads.mixin.RecipeManagerAccessor;
import net.blay09.mods.farmingforblockheads.network.MarketCategoriesMessage;
import net.blay09.mods.farmingforblockheads.network.MarketRecipesMessage;
import net.blay09.mods.farmingforblockheads.recipe.MarketRecipeDisplay;
import net.blay09.mods.farmingforblockheads.recipe.ModRecipes;
import net.blay09.mods.farmingforblockheads.registry.SimpleHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MarketBlockEntity
extends BalmBlockEntity
implements BalmMenuProvider<BlockPos> {
    public MarketBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.market.get(), pos, state);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.farmingforblockheads.market");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        List<RecipeDisplayEntry> displays = this.getRecipeDisplays();
        List<SimpleHolder<MarketCategory>> categories = this.getCategories(displays);
        MarketMenu menu = new MarketMenu(windowId, playerInventory, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.worldPosition));
        menu.setCategories(categories);
        menu.setRecipes(displays);
        return menu;
    }

    public BlockPos getScreenOpeningData(ServerPlayer serverPlayer) {
        return this.worldPosition;
    }

    public StreamCodec<RegistryFriendlyByteBuf, BlockPos> getScreenStreamCodec() {
        return BlockPos.STREAM_CODEC.cast();
    }

    private List<SimpleHolder<MarketCategory>> getCategories(List<RecipeDisplayEntry> displays) {
        Map<ResourceLocation, MarketCategory> categories = FarmingForBlockheadsAPI.getMarketCategories();
        Set usedCategories = displays.stream().map(it -> ((MarketRecipeDisplay)it.display()).category()).collect(Collectors.toSet());
        return usedCategories.stream().map(it -> SimpleHolder.of(it, (MarketCategory)categories.get(it))).filter(Objects::nonNull).toList();
    }

    private List<RecipeDisplayEntry> getRecipeDisplays() {
        RecipeManager recipeManager = this.level.getServer().getRecipeManager();
        ArrayList<RecipeDisplayEntry> result = new ArrayList<RecipeDisplayEntry>();
        if (recipeManager instanceof RecipeManagerAccessor) {
            RecipeManagerAccessor accessor = (RecipeManagerAccessor)recipeManager;
            Collection recipes = accessor.getRecipes().byType(ModRecipes.marketRecipeType);
            for (RecipeHolder recipeHolder : recipes) {
                recipeManager.listDisplaysForRecipe(recipeHolder.id(), result::add);
            }
        }
        return result;
    }

    public void openMenu(Player player) {
        Balm.getNetworking().openMenu(player, (MenuProvider)this);
        List<RecipeDisplayEntry> displays = this.getRecipeDisplays();
        List<SimpleHolder<MarketCategory>> categories = this.getCategories(displays);
        Balm.getNetworking().sendTo(player, (CustomPacketPayload)new MarketCategoriesMessage(categories));
        Balm.getNetworking().sendTo(player, (CustomPacketPayload)new MarketRecipesMessage(displays));
    }
}

