/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.blay09.mods.farmingforblockheads.block.entity.FeedingTroughBlockEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class FeedingTroughRenderer
implements BlockEntityRenderer<FeedingTroughBlockEntity, FeedingTroughRenderState> {
    private final float[] CONTENT_POSITIONS = new float[]{0.2f, 0.01f, 0.0f, -0.18f, 0.0f, 0.0f, 0.0f, -0.01f, -0.18f, 0.0f, -0.02f, 0.18f};
    private final ItemModelResolver itemModelResolver;

    public FeedingTroughRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public FeedingTroughRenderState createRenderState() {
        return new FeedingTroughRenderState();
    }

    public void extractRenderState(FeedingTroughBlockEntity blockEntity, FeedingTroughRenderState renderState, float delta, Vec3 vec, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        BlockEntityRenderState.extractBase((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        Level level = blockEntity.getLevel();
        ItemStack itemStack = blockEntity.getContentStack();
        renderState.count = itemStack.getCount();
        this.itemModelResolver.updateForTopItem(renderState.item, itemStack, ItemDisplayContext.FIXED, level, null, (int)renderState.blockPos.asLong());
    }

    public void submit(FeedingTroughRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (int i = 0; i < Math.max(1, Math.min(this.CONTENT_POSITIONS.length / 3, renderState.count / 12)); ++i) {
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.5f, 0.5f);
            poseStack.translate(x + this.CONTENT_POSITIONS[i * 3], y + this.CONTENT_POSITIONS[i * 3 + 1], z + this.CONTENT_POSITIONS[i * 3 + 2]);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            float scale = 0.5f;
            poseStack.scale(0.5f, 0.5f, 0.5f);
            renderState.item.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
    }

    public static class FeedingTroughRenderState
    extends BlockEntityRenderState {
        public final ItemStackRenderState item = new ItemStackRenderState();
        public int count;
    }
}

