/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.farmingforblockheads.client.render.MerchantRenderState;
import net.blay09.mods.farmingforblockheads.entity.MerchantEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.VillagerRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class MerchantRenderer
extends MobRenderer<MerchantEntity, VillagerRenderState, VillagerModel> {
    private static final ResourceLocation MERCHANT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"farmingforblockheads", (String)"textures/entity/merchant.png");
    private static final Map<ResourceLocation, ResourceLocation> verifiedTextures = new HashMap<ResourceLocation, ResourceLocation>();

    public MerchantRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new VillagerModel(context.bakeLayer(ModelLayers.VILLAGER)), 0.5f);
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getPlayerSkinRenderCache()));
    }

    public ResourceLocation getTextureLocation(VillagerRenderState state) {
        ResourceLocation textureLocation;
        if (state instanceof MerchantRenderState) {
            MerchantRenderState merchantRenderState = (MerchantRenderState)state;
            v0 = merchantRenderState.textureLocation;
        } else {
            v0 = textureLocation = null;
        }
        if (textureLocation == null) {
            return MERCHANT_TEXTURE;
        }
        return verifiedTextures.computeIfAbsent(textureLocation, it -> {
            if (Minecraft.getInstance().getResourceManager().getResource(it).isPresent()) {
                return it;
            }
            return MERCHANT_TEXTURE;
        });
    }

    public void submit(VillagerRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        int diggingAnimation;
        poseStack.pushPose();
        if (renderState instanceof MerchantRenderState) {
            MerchantRenderState merchantRenderState = (MerchantRenderState)renderState;
            v0 = merchantRenderState.diggingAnimation;
        } else {
            v0 = diggingAnimation = 0;
        }
        if (diggingAnimation > 0) {
            poseStack.translate(0.0, (double)(-diggingAnimation) * 0.05, 0.0);
        }
        super.submit((LivingEntityRenderState)renderState, poseStack, submitNodeCollector, cameraRenderState);
        poseStack.popPose();
    }

    public void extractRenderState(MerchantEntity entity, VillagerRenderState state, float delta) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, delta);
        if (state instanceof MerchantRenderState) {
            MerchantRenderState merchantRenderState = (MerchantRenderState)state;
            merchantRenderState.textureLocation = entity.getTextureLocation();
            merchantRenderState.diggingAnimation = entity.getDiggingAnimation();
        }
    }

    protected boolean shouldShowName(MerchantEntity entity, double distance) {
        return entity.getDiggingAnimation() <= 0 && super.shouldShowName((Mob)entity, distance);
    }

    public MerchantRenderState createRenderState() {
        return new MerchantRenderState();
    }
}

