/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.network;

import net.blay09.mods.farmingforblockheads.FarmingForBlockheads;
import net.blay09.mods.farmingforblockheads.menu.MarketMenu;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundPlaceGhostRecipePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;

public record MarketPlaceRecipeMessage(int containerId, RecipeDisplayId recipe, boolean useMaxItems) implements CustomPacketPayload
{
    public static StreamCodec<RegistryFriendlyByteBuf, MarketPlaceRecipeMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.CONTAINER_ID, MarketPlaceRecipeMessage::containerId, (StreamCodec)RecipeDisplayId.STREAM_CODEC, MarketPlaceRecipeMessage::recipe, (StreamCodec)ByteBufCodecs.BOOL, MarketPlaceRecipeMessage::useMaxItems, MarketPlaceRecipeMessage::new);
    public static final CustomPacketPayload.Type<MarketPlaceRecipeMessage> TYPE = new CustomPacketPayload.Type(FarmingForBlockheads.id("market_put_in_basket"));

    public static void handle(ServerPlayer player, MarketPlaceRecipeMessage message) {
        player.resetLastActionTime();
        if (!player.isSpectator() && player.containerMenu.containerId == message.containerId()) {
            if (!player.containerMenu.stillValid((Player)player)) {
                FarmingForBlockheads.logger.debug("Player {} interacted with invalid menu {}", (Object)player, (Object)player.containerMenu);
            } else {
                RecipeManager.ServerDisplayInfo serverDisplayInfo = player.level().getServer().getRecipeManager().getRecipeFromDisplay(message.recipe());
                if (serverDisplayInfo != null) {
                    MarketMenu marketMenu;
                    RecipeHolder recipeHolder = serverDisplayInfo.parent();
                    AbstractContainerMenu abstractContainerMenu = player.containerMenu;
                    if (abstractContainerMenu instanceof MarketMenu && (marketMenu = (MarketMenu)abstractContainerMenu).containsRecipeDisplayId(message.recipe())) {
                        if (recipeHolder.value().placementInfo().isImpossibleToPlace()) {
                            FarmingForBlockheads.logger.debug("Player {} tried to place impossible recipe {}", (Object)player, (Object)recipeHolder.id().location());
                            return;
                        }
                        RecipeBookMenu.PostPlaceAction postPlaceAction = marketMenu.handlePlacement(message.useMaxItems(), player.isCreative(), recipeHolder, player.level(), player.getInventory());
                        if (postPlaceAction == RecipeBookMenu.PostPlaceAction.PLACE_GHOST_RECIPE) {
                            player.connection.send((Packet)new ClientboundPlaceGhostRecipePacket(player.containerMenu.containerId, serverDisplayInfo.display().display()));
                        }
                    }
                }
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

