/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.activation_range;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.fish.WaterAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.entity.EntityTypeTest;
import org.jetbrains.annotations.Nullable;

public class EntityTypeTests {
    private static final Map<String, EntityTypeTest<?, ?>> ENTITY_TYPE_TESTS = new Object2ObjectOpenHashMap();
    public static final EntityTypeTest<? super Entity, ?> MOB = EntityTypeTests.register("mob", Mob.class);
    public static final EntityTypeTest<? super Entity, ?> MONSTER = EntityTypeTests.register("monster", Enemy.class);
    public static final EntityTypeTest<? super Entity, ?> RAIDER = EntityTypeTests.register("raider", Raider.class);
    public static final EntityTypeTest<? super Entity, ?> AMBIENT = EntityTypeTests.register("ambient", AmbientCreature.class);
    public static final EntityTypeTest<? super Entity, ?> ANIMAL = EntityTypeTests.register("animal", AgeableMob.class);
    public static final EntityTypeTest<? super Entity, ?> NEUTRAL = EntityTypeTests.register("neutral", NeutralMob.class);
    public static final EntityTypeTest<? super Entity, ?> WATER_ANIMAL = EntityTypeTests.register("water_animal", WaterAnimal.class);
    public static final EntityTypeTest<? super Entity, ?> FLYING_ANIMAL = EntityTypeTests.register("flying_animal", FlyingAnimal.class);
    public static final EntityTypeTest<? super Entity, ?> VILLAGER = EntityTypeTests.register("villager", Npc.class);
    public static final EntityTypeTest<? super Entity, ?> PROJECTILE = EntityTypeTests.register("projectile", Projectile.class);

    public static EntityTypeTest<? super Entity, ?> register(String key, Class<?> clazz) {
        EntityTypeTest matcher = EntityTypeTest.forClass(clazz);
        ENTITY_TYPE_TESTS.put(key, matcher);
        return matcher;
    }

    @Nullable
    public static EntityTypeTest<?, ?> get(String key) {
        return ENTITY_TYPE_TESTS.get(key);
    }

    @Nullable
    public static String getKey(EntityTypeTest<?, ?> entityTypeTest) {
        for (String key : ENTITY_TYPE_TESTS.keySet()) {
            EntityTypeTest<?, ?> value = ENTITY_TYPE_TESTS.get(key);
            if (value != entityTypeTest) continue;
            return key;
        }
        return null;
    }
}

