/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.mixin.features.mob_spawning;

import java.util.List;
import me.wesley1808.servercore.common.interfaces.IMobCategory;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.NaturalSpawner;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={NaturalSpawner.class}, priority=900)
public class NaturalSpawnerMixin {
    @ModifyVariable(method={"getFilteredSpawningCategories(Lnet/minecraft/world/level/NaturalSpawner$SpawnState;ZZZ)Ljava/util/List;"}, at=@At(value="HEAD"), index=3, argsOnly=true)
    private static boolean servercore$alwaysSpawnPersistent(boolean shouldSpawnPersistent) {
        return true;
    }

    @Redirect(method={"getFilteredSpawningCategories(Lnet/minecraft/world/level/NaturalSpawner$SpawnState;ZZZ)Ljava/util/List;"}, at=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=0))
    private static <T> boolean servercore$canSpawn(List<T> spawnCategories, T value, NaturalSpawner.SpawnState state) {
        MobCategory category = (MobCategory)value;
        if (category.getMaxInstancesPerChunk() <= 0) {
            return false;
        }
        int interval = IMobCategory.getSpawnInterval(category);
        if (interval > 1 && state.localMobCapCalculator.chunkMap.level.getGameTime() % (long)interval != 0L) {
            return false;
        }
        spawnCategories.add(value);
        return true;
    }
}

