/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.wrd.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.wrd.world.features.DeeplandsPortalFeature;
import net.mcreator.wrd.world.features.WesleysDungeonFeature;
import net.mcreator.wrd.world.features.WesleysNetherDungeonFeature;
import net.mcreator.wrd.world.features.ores.DeepsandFeature;
import net.mcreator.wrd.world.features.ores.MaulstoneFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class WrdModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"wrd");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> DEEPSAND = WrdModFeatures.register("deepsand", DeepsandFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, DeepsandFeature.GENERATE_BIOMES, DeepsandFeature::placedFeature));
    public static final RegistryObject<Feature<?>> MAULSTONE = WrdModFeatures.register("maulstone", MaulstoneFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, MaulstoneFeature.GENERATE_BIOMES, MaulstoneFeature::placedFeature));
    public static final RegistryObject<Feature<?>> DEEPLANDS_PORTAL = WrdModFeatures.register("deeplands_portal", DeeplandsPortalFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, DeeplandsPortalFeature.GENERATE_BIOMES, DeeplandsPortalFeature::placedFeature));
    public static final RegistryObject<Feature<?>> WESLEYS_DUNGEON = WrdModFeatures.register("wesleys_dungeon", WesleysDungeonFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, WesleysDungeonFeature.GENERATE_BIOMES, WesleysDungeonFeature::placedFeature));
    public static final RegistryObject<Feature<?>> WESLEYS_NETHER_DUNGEON = WrdModFeatures.register("wesleys_nether_dungeon", WesleysNetherDungeonFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, WesleysNetherDungeonFeature.GENERATE_BIOMES, WesleysNetherDungeonFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

