/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.wrd.network;

import java.util.function.Supplier;
import net.mcreator.wrd.WrdMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class WrdModVariables {
    public static double DungeonDifficulty = 0.0;
    public static double slowerdungeontimer = 0.0;
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        WrdMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        WrdMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        public int type;
        public SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            SavedData savedData = this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            if (savedData instanceof MapVariables) {
                MapVariables _mapvars = (MapVariables)savedData;
                _mapvars.read(buffer.m_130260_());
            } else {
                savedData = this.data;
                if (savedData instanceof WorldVariables) {
                    WorldVariables _worldvars = (WorldVariables)savedData;
                    _worldvars.read(buffer.m_130260_());
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.IDxp = message.data.IDxp;
                    variables.IDlvl = message.data.IDlvl;
                    variables.isPlayerPlaying = message.data.isPlayerPlaying;
                    variables.IDnextlevel = message.data.IDnextlevel;
                    variables.IDxpAdd = message.data.IDxpAdd;
                    variables.IDGemValue = message.data.IDGemValue;
                    variables.IDGemValueAdd = message.data.IDGemValueAdd;
                    variables.sacrificeCount = message.data.sacrificeCount;
                    variables.IDplayerReturn = message.data.IDplayerReturn;
                    variables.hasTrial = message.data.hasTrial;
                    variables.musicTimer = message.data.musicTimer;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double IDxp = 0.0;
        public double IDlvl = 0.0;
        public boolean isPlayerPlaying = false;
        public double IDnextlevel = 5000.0;
        public double IDxpAdd = 0.0;
        public double IDGemValue = 0.0;
        public double IDGemValueAdd = 0.0;
        public double sacrificeCount = 0.0;
        public double IDplayerReturn = 0.0;
        public boolean hasTrial = false;
        public double musicTimer = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                WrdMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("IDxp", this.IDxp);
            nbt.m_128347_("IDlvl", this.IDlvl);
            nbt.m_128379_("isPlayerPlaying", this.isPlayerPlaying);
            nbt.m_128347_("IDnextlevel", this.IDnextlevel);
            nbt.m_128347_("IDxpAdd", this.IDxpAdd);
            nbt.m_128347_("IDGemValue", this.IDGemValue);
            nbt.m_128347_("IDGemValueAdd", this.IDGemValueAdd);
            nbt.m_128347_("sacrificeCount", this.sacrificeCount);
            nbt.m_128347_("IDplayerReturn", this.IDplayerReturn);
            nbt.m_128379_("hasTrial", this.hasTrial);
            nbt.m_128347_("musicTimer", this.musicTimer);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.IDxp = nbt.m_128459_("IDxp");
            this.IDlvl = nbt.m_128459_("IDlvl");
            this.isPlayerPlaying = nbt.m_128471_("isPlayerPlaying");
            this.IDnextlevel = nbt.m_128459_("IDnextlevel");
            this.IDxpAdd = nbt.m_128459_("IDxpAdd");
            this.IDGemValue = nbt.m_128459_("IDGemValue");
            this.IDGemValueAdd = nbt.m_128459_("IDGemValueAdd");
            this.sacrificeCount = nbt.m_128459_("sacrificeCount");
            this.IDplayerReturn = nbt.m_128459_("IDplayerReturn");
            this.hasTrial = nbt.m_128471_("hasTrial");
            this.musicTimer = nbt.m_128459_("musicTimer");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("wrd", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "wrd_mapvars";
        public double lowerroomcounter = 0.0;
        public double bossroomcounter = 0.0;
        public double MusicOn = 0.0;
        public double specialroom = 0.0;
        public double minibossroom = 0.0;
        public double StructureCooldown = 0.0;
        public double SpecialPathQueue = 0.0;
        public double spawnHeart = 0.0;
        public double palaceSpawned = 0.0;
        public double heartsBeat = 0.0;
        public double yetiAttackTimer = 0.0;
        public boolean infiniteDungeonSetup = false;
        public double IDTimer = 0.0;
        public boolean isPlaying = false;
        public double IDPreTimer = 0.0;
        public String IDTimerDisplay = "\"\"";
        public double DungeonValue = 0.0;
        public double playing_players = 0.0;
        public double IDtimerAdd = 0.0;
        public double DungeonValueAdd = 0.0;
        public boolean IDExtraArenas = false;
        public boolean IDLockKey = false;
        public boolean ID50pBoss = false;
        public boolean IDExtraTraps = false;
        public boolean IDExtraGoldDrop = false;
        public boolean IDFoolsGold = false;
        public boolean IDExtraSpawners = false;
        public double IDRoomsPlaced = 0.0;
        public double DungeonType = 0.0;
        public double IDRoomcounterSacrifice = 0.0;
        public boolean IDHasSpawnedSacrificeRoom = false;
        public boolean IDMoreGemShops = false;
        public boolean allSacrificeRoom = false;
        public boolean IDpillagers = false;
        public boolean IDExtraMods = false;
        public boolean IDDoubleTime = false;
        public double IDDungeonType = -1.0;
        public double ActiveRing = 0.0;
        public double ActiveAmulet = 0.0;
        public double IDdifficulty = 0.0;
        public boolean hasPaidOut = false;
        public double IDSkullDirection = 0.0;
        public double IDSkullRoom1 = 0.0;
        public double IDSkullRoom2 = 0.0;
        public double IDSkullRoom3 = 0.0;
        public double IDSkullRoom4 = 0.0;
        public double IDSkullRoom5 = 0.0;
        public double IDSkullRoom6 = 0.0;
        public double IDKeyRoom = 0.0;
        public double IDSkullRoom7 = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.lowerroomcounter = nbt.m_128459_("lowerroomcounter");
            this.bossroomcounter = nbt.m_128459_("bossroomcounter");
            this.MusicOn = nbt.m_128459_("MusicOn");
            this.specialroom = nbt.m_128459_("specialroom");
            this.minibossroom = nbt.m_128459_("minibossroom");
            this.StructureCooldown = nbt.m_128459_("StructureCooldown");
            this.SpecialPathQueue = nbt.m_128459_("SpecialPathQueue");
            this.spawnHeart = nbt.m_128459_("spawnHeart");
            this.palaceSpawned = nbt.m_128459_("palaceSpawned");
            this.heartsBeat = nbt.m_128459_("heartsBeat");
            this.yetiAttackTimer = nbt.m_128459_("yetiAttackTimer");
            this.infiniteDungeonSetup = nbt.m_128471_("infiniteDungeonSetup");
            this.IDTimer = nbt.m_128459_("IDTimer");
            this.isPlaying = nbt.m_128471_("isPlaying");
            this.IDPreTimer = nbt.m_128459_("IDPreTimer");
            this.IDTimerDisplay = nbt.m_128461_("IDTimerDisplay");
            this.DungeonValue = nbt.m_128459_("DungeonValue");
            this.playing_players = nbt.m_128459_("playing_players");
            this.IDtimerAdd = nbt.m_128459_("IDtimerAdd");
            this.DungeonValueAdd = nbt.m_128459_("DungeonValueAdd");
            this.IDExtraArenas = nbt.m_128471_("IDExtraArenas");
            this.IDLockKey = nbt.m_128471_("IDLockKey");
            this.ID50pBoss = nbt.m_128471_("ID50pBoss");
            this.IDExtraTraps = nbt.m_128471_("IDExtraTraps");
            this.IDExtraGoldDrop = nbt.m_128471_("IDExtraGoldDrop");
            this.IDFoolsGold = nbt.m_128471_("IDFoolsGold");
            this.IDExtraSpawners = nbt.m_128471_("IDExtraSpawners");
            this.IDRoomsPlaced = nbt.m_128459_("IDRoomsPlaced");
            this.DungeonType = nbt.m_128459_("DungeonType");
            this.IDRoomcounterSacrifice = nbt.m_128459_("IDRoomcounterSacrifice");
            this.IDHasSpawnedSacrificeRoom = nbt.m_128471_("IDHasSpawnedSacrificeRoom");
            this.IDMoreGemShops = nbt.m_128471_("IDMoreGemShops");
            this.allSacrificeRoom = nbt.m_128471_("allSacrificeRoom");
            this.IDpillagers = nbt.m_128471_("IDpillagers");
            this.IDExtraMods = nbt.m_128471_("IDExtraMods");
            this.IDDoubleTime = nbt.m_128471_("IDDoubleTime");
            this.IDDungeonType = nbt.m_128459_("IDDungeonType");
            this.ActiveRing = nbt.m_128459_("ActiveRing");
            this.ActiveAmulet = nbt.m_128459_("ActiveAmulet");
            this.IDdifficulty = nbt.m_128459_("IDdifficulty");
            this.hasPaidOut = nbt.m_128471_("hasPaidOut");
            this.IDSkullDirection = nbt.m_128459_("IDSkullDirection");
            this.IDSkullRoom1 = nbt.m_128459_("IDSkullRoom1");
            this.IDSkullRoom2 = nbt.m_128459_("IDSkullRoom2");
            this.IDSkullRoom3 = nbt.m_128459_("IDSkullRoom3");
            this.IDSkullRoom4 = nbt.m_128459_("IDSkullRoom4");
            this.IDSkullRoom5 = nbt.m_128459_("IDSkullRoom5");
            this.IDSkullRoom6 = nbt.m_128459_("IDSkullRoom6");
            this.IDKeyRoom = nbt.m_128459_("IDKeyRoom");
            this.IDSkullRoom7 = nbt.m_128459_("IDSkullRoom7");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("lowerroomcounter", this.lowerroomcounter);
            nbt.m_128347_("bossroomcounter", this.bossroomcounter);
            nbt.m_128347_("MusicOn", this.MusicOn);
            nbt.m_128347_("specialroom", this.specialroom);
            nbt.m_128347_("minibossroom", this.minibossroom);
            nbt.m_128347_("StructureCooldown", this.StructureCooldown);
            nbt.m_128347_("SpecialPathQueue", this.SpecialPathQueue);
            nbt.m_128347_("spawnHeart", this.spawnHeart);
            nbt.m_128347_("palaceSpawned", this.palaceSpawned);
            nbt.m_128347_("heartsBeat", this.heartsBeat);
            nbt.m_128347_("yetiAttackTimer", this.yetiAttackTimer);
            nbt.m_128379_("infiniteDungeonSetup", this.infiniteDungeonSetup);
            nbt.m_128347_("IDTimer", this.IDTimer);
            nbt.m_128379_("isPlaying", this.isPlaying);
            nbt.m_128347_("IDPreTimer", this.IDPreTimer);
            nbt.m_128359_("IDTimerDisplay", this.IDTimerDisplay);
            nbt.m_128347_("DungeonValue", this.DungeonValue);
            nbt.m_128347_("playing_players", this.playing_players);
            nbt.m_128347_("IDtimerAdd", this.IDtimerAdd);
            nbt.m_128347_("DungeonValueAdd", this.DungeonValueAdd);
            nbt.m_128379_("IDExtraArenas", this.IDExtraArenas);
            nbt.m_128379_("IDLockKey", this.IDLockKey);
            nbt.m_128379_("ID50pBoss", this.ID50pBoss);
            nbt.m_128379_("IDExtraTraps", this.IDExtraTraps);
            nbt.m_128379_("IDExtraGoldDrop", this.IDExtraGoldDrop);
            nbt.m_128379_("IDFoolsGold", this.IDFoolsGold);
            nbt.m_128379_("IDExtraSpawners", this.IDExtraSpawners);
            nbt.m_128347_("IDRoomsPlaced", this.IDRoomsPlaced);
            nbt.m_128347_("DungeonType", this.DungeonType);
            nbt.m_128347_("IDRoomcounterSacrifice", this.IDRoomcounterSacrifice);
            nbt.m_128379_("IDHasSpawnedSacrificeRoom", this.IDHasSpawnedSacrificeRoom);
            nbt.m_128379_("IDMoreGemShops", this.IDMoreGemShops);
            nbt.m_128379_("allSacrificeRoom", this.allSacrificeRoom);
            nbt.m_128379_("IDpillagers", this.IDpillagers);
            nbt.m_128379_("IDExtraMods", this.IDExtraMods);
            nbt.m_128379_("IDDoubleTime", this.IDDoubleTime);
            nbt.m_128347_("IDDungeonType", this.IDDungeonType);
            nbt.m_128347_("ActiveRing", this.ActiveRing);
            nbt.m_128347_("ActiveAmulet", this.ActiveAmulet);
            nbt.m_128347_("IDdifficulty", this.IDdifficulty);
            nbt.m_128379_("hasPaidOut", this.hasPaidOut);
            nbt.m_128347_("IDSkullDirection", this.IDSkullDirection);
            nbt.m_128347_("IDSkullRoom1", this.IDSkullRoom1);
            nbt.m_128347_("IDSkullRoom2", this.IDSkullRoom2);
            nbt.m_128347_("IDSkullRoom3", this.IDSkullRoom3);
            nbt.m_128347_("IDSkullRoom4", this.IDSkullRoom4);
            nbt.m_128347_("IDSkullRoom5", this.IDSkullRoom5);
            nbt.m_128347_("IDSkullRoom6", this.IDSkullRoom6);
            nbt.m_128347_("IDKeyRoom", this.IDKeyRoom);
            nbt.m_128347_("IDSkullRoom7", this.IDSkullRoom7);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                WrdMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_142572_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "wrd_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                WrdMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.IDxp = original.IDxp;
            clone.IDlvl = original.IDlvl;
            clone.IDnextlevel = original.IDnextlevel;
            clone.IDxpAdd = original.IDxpAdd;
            clone.IDplayerReturn = original.IDplayerReturn;
            if (!event.isWasDeath()) {
                clone.isPlayerPlaying = original.isPlayerPlaying;
                clone.IDGemValue = original.IDGemValue;
                clone.IDGemValueAdd = original.IDGemValueAdd;
                clone.sacrificeCount = original.sacrificeCount;
                clone.hasTrial = original.hasTrial;
                clone.musicTimer = original.musicTimer;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getPlayer().f_19853_);
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getPlayer().f_19853_);
                if (mapdata != null) {
                    WrdMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    WrdMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getPlayer().f_19853_.m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getPlayer().f_19853_)) != null) {
                WrdMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

