/*
 * Decompiled with CFR 0.152.
 */
package com.wundercroft.scrollsnscripting.block.custom;

import com.mojang.serialization.MapCodec;
import com.wundercroft.scrollsnscripting.block.entities.custom.ScriptingTableEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ScriptingTable
extends BaseEntityBlock {
    public static final MapCodec<ScriptingTable> CODEC = ScriptingTable.simpleCodec(ScriptingTable::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final VoxelShape SHAPE_BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape SHAPE_POST = Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    public static final VoxelShape SHAPE_COMMON = Shapes.or((VoxelShape)SHAPE_BASE, (VoxelShape)SHAPE_POST);
    public static final VoxelShape SHAPE_TOP_PLATE = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final VoxelShape SHAPE_COLLISION = Shapes.or((VoxelShape)SHAPE_COMMON, (VoxelShape)SHAPE_TOP_PLATE);
    public static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)Block.box((double)1.0, (double)10.0, (double)0.0, (double)5.333333, (double)14.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)5.333333, (double)12.0, (double)0.0, (double)9.666667, (double)16.0, (double)16.0), Block.box((double)9.666667, (double)14.0, (double)0.0, (double)14.0, (double)18.0, (double)16.0), SHAPE_COMMON});
    public static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)10.0, (double)1.0, (double)16.0, (double)14.0, (double)5.333333), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)12.0, (double)5.333333, (double)16.0, (double)16.0, (double)9.666667), Block.box((double)0.0, (double)14.0, (double)9.666667, (double)16.0, (double)18.0, (double)14.0), SHAPE_COMMON});
    public static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)Block.box((double)10.666667, (double)10.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)6.333333, (double)12.0, (double)0.0, (double)10.666667, (double)16.0, (double)16.0), Block.box((double)2.0, (double)14.0, (double)0.0, (double)6.333333, (double)18.0, (double)16.0), SHAPE_COMMON});
    public static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)10.0, (double)10.666667, (double)16.0, (double)14.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)12.0, (double)6.333333, (double)16.0, (double)16.0, (double)10.666667), Block.box((double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)18.0, (double)6.333333), SHAPE_COMMON});
    private static final int PAGE_CHANGE_IMPULSE_TICKS = 2;

    public MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public ScriptingTable(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return SHAPE_COMMON;
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_COLLISION;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_COMMON;
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ScriptingTableEntity(pos, state);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ScriptingTableEntity) {
            ScriptingTableEntity scriptingTableEntity = (ScriptingTableEntity)blockEntity;
            if (!level.isClientSide()) {
                ((ServerPlayer)player).openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)scriptingTableEntity, (Component)Component.literal((String)"Scripting Table")), pos);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }
}

