/*
 * Decompiled with CFR 0.152.
 */
package com.wundercroft.scrollsnscripting.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BoundScrollItem
extends Item {
    public BoundScrollItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        PotionContents contents;
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && !stack.isEmpty() && (contents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS)) != null) {
            for (MobEffectInstance effect : contents.getAllEffects()) {
                player.addEffect(new MobEffectInstance(effect));
            }
            EquipmentSlot slot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            stack.hurtAndBreak(1, (LivingEntity)player, slot);
            player.getCooldowns().addCooldown((Item)this, 1200);
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        PotionContents contents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (contents != null) {
            Iterable effects = contents.getAllEffects();
            if (effects.iterator().hasNext()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.scrollsnscripting.bound_effect").withStyle(ChatFormatting.GRAY));
                for (MobEffectInstance effect : effects) {
                    tooltip.add((Component)Component.literal((String)" - ").append(((MobEffect)effect.getEffect().value()).getDisplayName()).withStyle(ChatFormatting.AQUA));
                }
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.scrollsnscripting.no_effect").withStyle(ChatFormatting.DARK_GRAY));
            }
        }
    }
}

