/*
 * Decompiled with CFR 0.152.
 */
package com.wundercroft.scrollsnscripting.screen.custom;

import com.wundercroft.scrollsnscripting.block.ModBlocks;
import com.wundercroft.scrollsnscripting.block.entities.custom.ScriptingTableEntity;
import com.wundercroft.scrollsnscripting.item.ModItems;
import com.wundercroft.scrollsnscripting.screen.ModMenuTypes;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class ScriptingTableMenu
extends AbstractContainerMenu {
    public final ScriptingTableEntity blockEntity;
    private final Level level;
    private static final int SLOT_0_OFFSET_X = 25;
    private static final int SLOT_1_OFFSET_X = 52;
    private static final int SLOT_2_OFFSET_X = 79;
    private static final int SLOT_3_OFFSET_X = 133;
    private static final int SLOT_OFFSET_Y = 48;
    private static final int INVENTORY_OFFSET_X = 8;
    private static final int INVENTORY_OFFSET_Y = 84;
    private static final int HOTBAR_OFFSET_X = 8;
    private static final int HOTBAR_OFFSET_Y = 142;
    private static final ResourceLocation ADVANCEMENT_6A_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"scrollsnscripting", (String)"advancement_6a");
    private static final ResourceLocation ADVANCEMENT_6B_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"scrollsnscripting", (String)"advancement_6b");
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int INVENTORY_SLOT_COUNT = 4;

    public ScriptingTableMenu(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerId, inventory, inventory.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public ScriptingTableMenu(int containerId, Inventory inventory, BlockEntity blockEntity) {
        super((MenuType)ModMenuTypes.SCRIPTING_TABLE_MENU.get(), containerId);
        this.blockEntity = (ScriptingTableEntity)blockEntity;
        this.level = inventory.player.level();
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.inventory, 0, 25, 48){

            public boolean mayPlace(ItemStack stack) {
                return stack.isEnchanted() || stack.is(Items.ENCHANTED_BOOK) || stack.is(Items.POTION);
            }

            public int getMaxStackSize() {
                return 1;
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.inventory, 1, 52, 48){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(Items.BOOK) || stack.is(ModItems.EMPTY_SCROLL);
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.inventory, 2, 79, 48){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(Items.EXPERIENCE_BOTTLE);
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.inventory, 3, 133, 48){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }
        });
    }

    public ItemStack quickMoveStack(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 40, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 40) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public boolean stillValid(Player player) {
        return ScriptingTableMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)ModBlocks.SCRIPTING_TABLE.get()));
    }

    public void removed(Player player) {
        if (player instanceof ServerPlayer) {
            ItemStack itemstack = this.getCarried();
            if (!itemstack.isEmpty()) {
                if (player.isAlive() && !((ServerPlayer)player).hasDisconnected()) {
                    player.getInventory().placeItemBackInInventory(itemstack);
                } else {
                    player.drop(itemstack, false);
                }
                this.setCarried(ItemStack.EMPTY);
            }
            for (int i = 0; i < 4; ++i) {
                ItemStack stack = this.blockEntity.inventory.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                player.getInventory().placeItemBackInInventory(stack);
                this.blockEntity.inventory.setStackInSlot(i, ItemStack.EMPTY);
            }
        }
    }

    public boolean clickMenuButton(Player player, int id) {
        if (id == 0) {
            ItemStack source = this.blockEntity.inventory.getStackInSlot(0);
            ItemStack writeable = this.blockEntity.inventory.getStackInSlot(1);
            ItemStack bottle = this.blockEntity.inventory.getStackInSlot(2);
            ItemStack output = this.blockEntity.inventory.getStackInSlot(3);
            if (!source.isEmpty() && (source.isEnchanted() || source.getItem() == Items.ENCHANTED_BOOK) && writeable.getItem() == Items.BOOK && writeable.getCount() >= 1 && bottle.getItem() == Items.EXPERIENCE_BOTTLE && bottle.getCount() >= 1 && output.isEmpty()) {
                if (source.getItem() == Items.ENCHANTED_BOOK) {
                    this.blockEntity.inventory.setStackInSlot(3, source.copy());
                } else {
                    ItemStack enchantedBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
                    ItemEnchantments enchantments = (ItemEnchantments)source.get(DataComponents.ENCHANTMENTS);
                    enchantedBook.set(DataComponents.STORED_ENCHANTMENTS, (Object)enchantments);
                    this.blockEntity.inventory.setStackInSlot(3, enchantedBook);
                }
                writeable.shrink(1);
                bottle.shrink(1);
                this.level.playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.5f, 1.0f);
                if (player instanceof ServerPlayer) {
                    AdvancementProgress progress;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    MinecraftServer server = serverPlayer.server;
                    AdvancementHolder advancementHolder = server.getAdvancements().get(ADVANCEMENT_6A_LOCATION);
                    if (advancementHolder != null && !(progress = serverPlayer.getAdvancements().getOrStartProgress(advancementHolder)).isDone()) {
                        for (String criterion : progress.getRemainingCriteria()) {
                            serverPlayer.getAdvancements().award(advancementHolder, criterion);
                        }
                    }
                }
                return true;
            }
            if (!source.isEmpty() && source.getItem() == Items.POTION && writeable.getItem() == ModItems.EMPTY_SCROLL.get() && writeable.getCount() >= 1 && bottle.getItem() == Items.EXPERIENCE_BOTTLE && bottle.getCount() >= 1 && output.isEmpty()) {
                ItemStack boundScroll = new ItemStack((ItemLike)ModItems.BOUND_SCROLL.get());
                PotionContents effects = (PotionContents)source.get(DataComponents.POTION_CONTENTS);
                boundScroll.set(DataComponents.POTION_CONTENTS, (Object)effects);
                this.blockEntity.inventory.setStackInSlot(3, boundScroll);
                writeable.shrink(1);
                bottle.shrink(1);
                this.level.playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.5f, 1.0f);
                if (player instanceof ServerPlayer) {
                    AdvancementProgress progress;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    MinecraftServer server = serverPlayer.server;
                    AdvancementHolder advancementHolder = server.getAdvancements().get(ADVANCEMENT_6B_LOCATION);
                    if (advancementHolder != null && !(progress = serverPlayer.getAdvancements().getOrStartProgress(advancementHolder)).isDone()) {
                        for (String criterion : progress.getRemainingCriteria()) {
                            serverPlayer.getAdvancements().award(advancementHolder, criterion);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }
}

