/*
 * Decompiled with CFR 0.152.
 */
package com.wundercroft.scrollsnscripting.screen.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wundercroft.scrollsnscripting.screen.custom.ScriptingTableMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ScriptingTableScreen
extends AbstractContainerScreen<ScriptingTableMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"scrollsnscripting", (String)"textures/gui/scripting_table/scripting_table_gui.png");
    private static final ResourceLocation SPELLBOOK_ICON = ResourceLocation.fromNamespaceAndPath((String)"scrollsnscripting", (String)"textures/gui/scripting_table/spellbook.png");
    private static final int SPELLBOOK_OFFSET_X = 133;
    private static final int SPELLBOOK_OFFSET_Y = 8;
    private static final int SPELLBOOK_SIZE = 32;
    private static final ResourceLocation SLOT_1_OVERLAY_A = ResourceLocation.fromNamespaceAndPath((String)"scrollsnscripting", (String)"textures/gui/scripting_table/book_outline.png");
    private static final ResourceLocation SLOT_1_OVERLAY_B = ResourceLocation.fromNamespaceAndPath((String)"scrollsnscripting", (String)"textures/gui/scripting_table/scroll_outline.png");
    private static final int SLOT_1_OVERLAY_OFFSET_X = 52;
    private static final int SLOT_1_OVERLAY_OFFSET_Y = 48;
    private static final int SLOT_1_OVERLAY_SIZE = 16;
    private static final ResourceLocation SLOT_2_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"scrollsnscripting", (String)"textures/gui/scripting_table/bottle_outline.png");
    private static final int SLOT_2_OVERLAY_OFFSET_X = 79;
    private static final int SLOT_2_OVERLAY_OFFSET_Y = 48;
    private static final int SLOT_2_OVERLAY_SIZE = 16;
    public static final ResourceLocation QUILL_BUTTON = ResourceLocation.fromNamespaceAndPath((String)"scrollsnscripting", (String)"textures/gui/scripting_table/scripting_quill.png");
    public static final ResourceLocation QUILL_BUTTON_HOVER = ResourceLocation.fromNamespaceAndPath((String)"scrollsnscripting", (String)"textures/gui/scripting_table/scripting_quill_hover.png");
    private static final int BUTTON_OFFSET_X = 106;
    private static final int BUTTON_OFFSET_Y = 48;
    private static final int BUTTON_SIZE = 16;
    private static final int TOGGLE_INTERVAL = 20;
    private int bgX = 0;
    private int bgY = 0;

    public ScriptingTableScreen(ScriptingTableMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.bgX = x;
        this.bgY = y;
        guiGraphics.blit(GUI_TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 176, 166);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        this.renderCustomImage(guiGraphics, mouseX, mouseY, 25, 48, 16, 16, null, "Place enchanted items or potions here");
        this.renderCustomImage(guiGraphics, mouseX, mouseY, 133, 8, 32, 32, SPELLBOOK_ICON, "Can copy enchantments to books or bind potion effects to scrolls");
        boolean toggle = Minecraft.getInstance().level.getGameTime() / 20L % 2L == 0L;
        ResourceLocation slot1Overlay = toggle ? SLOT_1_OVERLAY_A : SLOT_1_OVERLAY_B;
        this.renderCustomImage(guiGraphics, mouseX, mouseY, 52, 48, 16, 16, slot1Overlay, "Place empty books or scrolls here");
        this.renderCustomImage(guiGraphics, mouseX, mouseY, 79, 48, 16, 16, SLOT_2_OVERLAY, "Place bottles'o'enchanting here");
        this.renderQuillButton(guiGraphics, mouseX, mouseY, 106, 48, 16, 16, QUILL_BUTTON, QUILL_BUTTON_HOVER, "Inscribe enchantments");
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)""), button -> {
            if (this.minecraft != null && this.minecraft.player != null) {
                this.minecraft.gameMode.handleInventoryButtonClick(((ScriptingTableMenu)this.menu).containerId, 0);
            }
        }).bounds(this.leftPos + 106 - 2, this.topPos + 48 - 2, 20, 20).build());
    }

    private void renderCustomImage(GuiGraphics guiGraphics, int mouseX, int mouseY, int posX, int posY, int width, int height, ResourceLocation texture, String tooltip) {
        boolean hovered;
        int x = this.bgX + posX;
        int y = this.bgY + posY;
        boolean bl = hovered = mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
        if (hovered) {
            guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)tooltip), mouseX, mouseY - 16);
        }
        if (texture == null) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        guiGraphics.blit(texture, x, y, 0.0f, 0.0f, width, height, width, height);
    }

    private void renderQuillButton(GuiGraphics guiGraphics, int mouseX, int mouseY, int posX, int posY, int width, int height, ResourceLocation normalTexture, ResourceLocation hoverTexture, String tooltip) {
        boolean hovered;
        int x = this.bgX + posX;
        int y = this.bgY + posY;
        boolean bl = hovered = mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
        if (hovered) {
            guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)tooltip), mouseX, mouseY);
        }
        ResourceLocation texture = hovered ? hoverTexture : normalTexture;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        guiGraphics.blit(texture, x, y, 0.0f, 0.0f, width, height, width, height);
    }
}

