/*
 * Decompiled with CFR 0.152.
 */
package io.github.timtaran.deote.mixin;

import io.github.timtaran.deote.DisableElytraOutsideTheEnd;
import io.github.timtaran.deote.GlobalStorage;
import io.github.timtaran.deote.config.WorkingMode;
import java.lang.reflect.Method;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FireworkRocketItem.class})
public class PreventFireworkBoostingMixin {
    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void init(Level level, Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> callbackInfo) {
        if (GlobalStorage.deoteConfig.workingMode == WorkingMode.FIREWORKS) {
            try {
                if (level.dimension() != Level.END) {
                    Method m = Entity.class.getDeclaredMethod("getSharedFlag", Integer.TYPE);
                    m.setAccessible(true);
                    boolean isGliding = (Boolean)m.invoke((Object)player, 7);
                    if (isGliding) {
                        callbackInfo.setReturnValue((Object)InteractionResultHolder.pass((Object)player.getItemInHand(interactionHand)));
                        if (GlobalStorage.deoteConfig.warningMessageEnabled && !level.isClientSide()) {
                            player.displayClientMessage((Component)Component.literal((String)GlobalStorage.deoteConfig.fireworksDisabledMessage), true);
                        }
                        callbackInfo.cancel();
                    }
                }
            }
            catch (Exception exception) {
                DisableElytraOutsideTheEnd.LOGGER.error(exception.getMessage());
            }
        }
    }
}

